/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIota
extends Iota {
    public static IotaType<EntityIota> TYPE = new IotaType<EntityIota>(){

        @Override
        @Nullable
        public EntityIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast(tag, CompoundTag.TYPE);
            Tag uuidTag = ctag.get("uuid");
            if (uuidTag == null) {
                return null;
            }
            UUID uuid = NbtUtils.loadUUID((Tag)uuidTag);
            Entity entity = world.getEntity(uuid);
            if (entity == null) {
                return null;
            }
            return new EntityIota(entity);
        }

        @Override
        public Component display(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return Component.translatable((String)"hexcasting.spelldata.entity.whoknows");
            }
            CompoundTag ctag = (CompoundTag)tag;
            if (!ctag.contains("name", 8)) {
                return Component.translatable((String)"hexcasting.spelldata.entity.whoknows");
            }
            String nameJson = ctag.getString("name");
            return Component.Serializer.fromJsonLenient((String)nameJson).withStyle(ChatFormatting.AQUA);
        }

        @Override
        public int color() {
            return -11141121;
        }
    };

    public EntityIota(@NotNull Entity e) {
        super(HexIotaTypes.ENTITY, e);
    }

    public Entity getEntity() {
        return (Entity)this.payload;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!EntityIota.typesMatch(this, that)) return false;
        if (!(that instanceof EntityIota)) return false;
        EntityIota dent = (EntityIota)that;
        if (this.getEntity() != dent.getEntity()) return false;
        return true;
    }

    @Override
    public boolean isTruthy() {
        return true;
    }

    @Override
    @NotNull
    public Tag serialize() {
        CompoundTag out = new CompoundTag();
        out.putUUID("uuid", this.getEntity().getUUID());
        out.putString("name", Component.Serializer.toJson((Component)this.getEntityNameWithInline(true)));
        return out;
    }

    @Override
    public Component display() {
        return this.getEntityNameWithInline(false).copy().withStyle(ChatFormatting.AQUA);
    }

    private Component getEntityNameWithInline(boolean fearSerializer) {
        MutableComponent baseName = this.getEntity().getName().copy();
        Component inlineEnt = null;
        Entity entity = this.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            inlineEnt = new PlayerHeadData(player.getGameProfile()).asText(!fearSerializer);
            inlineEnt = inlineEnt.plainCopy().withStyle(InlineAPI.INSTANCE.withSizeModifier(inlineEnt.getStyle(), 1.5));
        } else {
            inlineEnt = fearSerializer ? EntityInlineData.fromType((EntityType)this.getEntity().getType()).asText(!fearSerializer) : EntityInlineData.fromEntity((Entity)this.getEntity()).asText(!fearSerializer);
        }
        return baseName.append((Component)Component.literal((String)": ")).append(inlineEnt);
    }
}

