/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.msgs.MsgNewSpiralPatternsS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PackagedItemCastEnv
extends PlayerBasedCastEnv {
    protected EvalSound sound = HexEvalSounds.NOTHING;

    public PackagedItemCastEnv(ServerPlayer caster, InteractionHand castingHand) {
        super(caster, castingHand);
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        Iota iota = result.component1();
        if (iota instanceof PatternIota) {
            PatternIota patternIota = (PatternIota)iota;
            MsgNewSpiralPatternsS2C packet = new MsgNewSpiralPatternsS2C(this.caster.getUUID(), List.of(patternIota.getPattern()), 140);
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(this.caster, packet);
            IXplatAbstractions.INSTANCE.sendPacketTracking((Entity)this.caster, packet);
        }
        this.sound = this.sound.greaterOf(result.getSound());
    }

    @Override
    public long extractMediaEnvironment(long costLeft, boolean simulate) {
        if (this.caster.isCreative()) {
            return 0L;
        }
        ItemStack casterStack = this.caster.getItemInHand(this.castingHand);
        ADHexHolder casterHexHolder = IXplatAbstractions.INSTANCE.findHexHolder(casterStack);
        if (casterHexHolder == null) {
            return costLeft;
        }
        boolean canCastFromInv = casterHexHolder.canDrawMediaFromInventory();
        ADMediaHolder casterMediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(casterStack);
        if (casterMediaHolder != null) {
            long extracted = casterMediaHolder.withdrawMedia((int)costLeft, simulate);
            costLeft -= extracted;
        }
        if (canCastFromInv && costLeft > 0L) {
            costLeft = this.extractMediaFromInventory(costLeft, this.canOvercast(), simulate);
        }
        return costLeft;
    }

    @Override
    public InteractionHand getCastingHand() {
        return this.castingHand;
    }

    @Override
    public FrozenPigment getPigment() {
        ItemStack casterStack = this.caster.getItemInHand(this.castingHand);
        ADHexHolder casterHexHolder = IXplatAbstractions.INSTANCE.findHexHolder(casterStack);
        if (casterHexHolder == null) {
            return IXplatAbstractions.INSTANCE.getPigment((Player)this.caster);
        }
        FrozenPigment hexHolderPigment = casterHexHolder.getPigment();
        if (hexHolderPigment != null) {
            return hexHolderPigment;
        }
        return IXplatAbstractions.INSTANCE.getPigment((Player)this.caster);
    }

    public EvalSound getSound() {
        return this.sound;
    }
}

