/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionStringMethod
implements IPartialExpression {
    private static final Map<String, ZenNativeMember> members = new HashMap<String, ZenNativeMember>();
    private static boolean initialised = false;
    private final ZenPosition position;
    private final Expression source;
    private final String methodName;
    private final List<IJavaMethod> methods;

    public ExpressionStringMethod(ZenPosition position, Expression expression, String method) {
        this.position = position;
        this.source = expression;
        this.methodName = method;
        this.methods = members.get(method).getMethods();
    }

    public static boolean hasMethod(String name, ITypeRegistry typeRegistry) {
        if (!initialised) {
            ExpressionStringMethod.initialise(typeRegistry);
        }
        return members.containsKey(name);
    }

    private static boolean checkMethod(Method method) {
        for (Class<Object> clazz : method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(Character.TYPE) && !clazz.isAssignableFrom(char[].class)) continue;
            return false;
        }
        return method.getReturnType().isAssignableFrom(Character.TYPE) || method.getReturnType().isAssignableFrom(char[].class) ? false : (method.getModifiers() & 8) == 0;
    }

    private static void initialise(ITypeRegistry typeRegistry) {
        for (Method method : String.class.getMethods()) {
            if (!ExpressionStringMethod.checkMethod(method)) continue;
            String methodName = method.getName();
            members.putIfAbsent(methodName, new ZenNativeMember());
            members.get(methodName).addMethod(new JavaMethod(method, typeRegistry));
        }
        initialised = true;
    }

    @Override
    public ZenType getType() {
        return ZenType.ANY;
    }

    @Override
    public ZenType toType(IEnvironmentGlobal environment) {
        return ZenType.ANY;
    }

    @Override
    public Expression eval(IEnvironmentGlobal environment) {
        for (IJavaMethod method : this.methods) {
            if (!method.accepts(0)) continue;
            return new ExpressionCallVirtual(this.position, environment, method, this.source.eval(environment), new Expression[0]);
        }
        environment.error(this.position, "Cannot evaluate a StringMethod");
        return new ExpressionInvalid(this.position);
    }

    @Override
    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        environment.error(position, "Cannot assign to a String method");
        return new ExpressionInvalid(position);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        environment.error(position, "Cannot get the member of a String method");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        IJavaMethod method = JavaMethod.select(false, this.methods, environment, values);
        if (method == null) {
            environment.error(position, StringUtil.methodMatchingError(this.methods, values));
            return new ExpressionInvalid(position);
        }
        return new ExpressionCallVirtual(position, environment, method, this.source.eval(environment), values);
    }

    @Override
    public ZenType[] predictCallTypes(int numArguments) {
        return JavaMethod.predict(members.get(this.methodName).getMethods(), numArguments);
    }

    @Override
    public IZenSymbol toSymbol() {
        throw new UnsupportedOperationException("Cannot get a symbol from a String method");
    }
}

