/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mods.jei.commands;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mods.jei.JEIAddonPlugin;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeWrapper;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;

public class ConflictCommand
extends CraftTweakerCommand {
    public static final CraftRecipeEntryComparator CRAFT_RECIPE_ENTRY_COMPARATOR = new CraftRecipeEntryComparator();
    private List<CraftingRecipeEntry> craftingRecipeEntries = new ArrayList<CraftingRecipeEntry>();
    private TIntObjectMap<Range<Integer>> rangeMap;

    public ConflictCommand() {
        super("conflict");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)"\u00a72/ct conflict", (String)"/ct conflict", (boolean)true), SpecialMessagesChat.getNormalMessage((String)" \u00a73Lists all conflicting crafting recipes in the game"), SpecialMessagesChat.getNormalMessage((String)" \u00a73Might take a bit of time depending on the size of the pack"), SpecialMessagesChat.getNormalMessage((String)" \u00a73This needs to be run on a client and with JEI installed")});
    }

    public void executeCommand(MinecraftServer server, final ICommandSender sender, String[] args) {
        if (JEIAddonPlugin.recipeRegistry == null || !Loader.isModLoaded((String)"jei")) {
            sender.sendMessage(SpecialMessagesChat.getNormalMessage((String)"\u00a74This command can only be executed on the Client and with JEI installed"));
            CraftTweakerAPI.logWarning((String)"JEI plugin not loaded!");
        } else {
            sender.sendMessage(SpecialMessagesChat.getNormalMessage((String)"\u00a76Running Conflict scan. This might take a while"));
            new Thread("ConflictScan_mc_thread"){

                @Override
                public void run() {
                    try {
                        ConflictCommand.this.runConflictScan();
                        sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"Conflicting Recipe list generated", (ICommandSender)sender));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void runConflictScan() {
        if (JEIAddonPlugin.recipeRegistry == null || !Loader.isModLoaded((String)"jei")) {
            CraftTweakerAPI.logWarning((String)"JEI plugin not loaded yet!");
            CraftTweakerAPI.logWarning((String)"This command can only be used on a client and with JEI installed");
            return;
        }
        this.craftingRecipeEntries.clear();
        if (this.rangeMap != null) {
            this.rangeMap.clear();
        }
        this.gatherRecipes();
        this.craftingRecipeEntries.sort(CRAFT_RECIPE_ENTRY_COMPARATOR);
        this.rangeMap = this.getRangeForSize();
        this.rangeMap.forEachEntry((k, v) -> {
            CraftTweaker.LOG.info(k + ": " + v);
            return true;
        });
        ArrayList<Map.Entry<CraftingRecipeEntry, CraftingRecipeEntry>> conflictingRecipes = new ArrayList<Map.Entry<CraftingRecipeEntry, CraftingRecipeEntry>>();
        int maxCount = this.craftingRecipeEntries.size();
        float lastProgress = 0.0f;
        for (int i = 0; i < maxCount; ++i) {
            this.craftingRecipeEntries.get(i).checkAllConflicting(conflictingRecipes);
            float progress = (float)i / (float)maxCount;
            if (!((double)(progress - lastProgress) > 0.05)) continue;
            int percentage = (int)(progress * 100.0f);
            CraftTweaker.LOG.info("Current Progress on the scan: " + percentage + "%");
            lastProgress = progress;
        }
        CraftTweakerAPI.logInfo((String)("Conflicting: " + conflictingRecipes.size()));
        conflictingRecipes.forEach(it -> {
            String shape1 = ((CraftingRecipeEntry)it.getKey()).shapedRecipe ? "[Shaped] " : "[Shapeless] ";
            String shape2 = ((CraftingRecipeEntry)it.getValue()).shapedRecipe ? "[Shaped] " : "[Shapeless] ";
            String name1 = "<" + ((CraftingRecipeEntry)it.getKey()).output.getItem().getRegistryName() + ":" + ((CraftingRecipeEntry)it.getKey()).output.getMetadata() + "> * " + ((CraftingRecipeEntry)it.getKey()).output.getCount();
            String name2 = "<" + ((CraftingRecipeEntry)it.getValue()).output.getItem().getRegistryName() + ":" + ((CraftingRecipeEntry)it.getValue()).output.getMetadata() + "> * " + ((CraftingRecipeEntry)it.getValue()).output.getCount();
            String name1dp = "[" + ((CraftingRecipeEntry)it.getKey()).recipeName + "](" + ((CraftingRecipeEntry)it.getKey()).output.getDisplayName() + ") ";
            String name2dp = "[" + ((CraftingRecipeEntry)it.getValue()).recipeName + "](" + ((CraftingRecipeEntry)it.getValue()).output.getDisplayName() + ") ";
            CraftTweakerAPI.logInfo((String)(shape1 + name1dp + name1 + " conflicts with " + shape2 + name2dp + name2));
        });
    }

    private TIntObjectMap<Range<Integer>> getRangeForSize() {
        TIntObjectHashMap rangeMap = new TIntObjectHashMap();
        int recipeSize = 0;
        int recipeCount = 0;
        for (int i = 0; i < this.craftingRecipeEntries.size(); ++i) {
            CraftingRecipeEntry current = this.craftingRecipeEntries.get(i);
            if (recipeSize == current.recipeSize) {
                ++recipeCount;
            }
            if (current.recipeSize <= recipeSize) continue;
            rangeMap.put(recipeSize, (Object)Range.closedOpen((Comparable)Integer.valueOf(i - recipeCount), (Comparable)Integer.valueOf(i)));
            recipeSize = current.recipeSize;
            recipeCount = 1;
        }
        rangeMap.put(recipeSize, (Object)Range.closedOpen((Comparable)Integer.valueOf(this.craftingRecipeEntries.size() - recipeCount), (Comparable)Integer.valueOf(this.craftingRecipeEntries.size())));
        return rangeMap;
    }

    private void gatherRecipes() {
        IRecipeRegistry reg = JEIAddonPlugin.recipeRegistry;
        for (IRecipeCategory category : reg.getRecipeCategories()) {
            if (!(category instanceof CraftingRecipeCategory)) continue;
            List wrappers = reg.getRecipeWrappers(category);
            for (IRecipeWrapper wrapper : wrappers) {
                ItemStack output;
                if (!(wrapper instanceof ICraftingRecipeWrapper) || wrapper instanceof TippedArrowRecipeWrapper) continue;
                ICraftingRecipeWrapper wrap = (ICraftingRecipeWrapper)wrapper;
                Ingredients ing = new Ingredients();
                wrap.getIngredients((IIngredients)ing);
                List inputs = ing.getInputs(VanillaTypes.ITEM);
                List outputs = ing.getOutputs(VanillaTypes.ITEM);
                ItemStack itemStack = outputs.size() > 0 ? (outputs.get(0) != null ? (((List)outputs.get(0)).size() > 0 ? (ItemStack)((List)outputs.get(0)).get(0) : null) : null) : (output = null);
                if (output == null) continue;
                for (List input : inputs) {
                    if (input.size() <= 50) continue;
                    CraftTweakerAPI.logInfo((String)("trimming list of size = " + input.size() + " for recipe with output " + output.getItem().getRegistryName() + ":" + output.getMetadata()));
                    HashSet<AbstractMap.SimpleEntry<Item, Integer>> hasAlready = new HashSet<AbstractMap.SimpleEntry<Item, Integer>>();
                    Iterator iter = input.iterator();
                    while (iter.hasNext()) {
                        ItemStack stack = (ItemStack)iter.next();
                        AbstractMap.SimpleEntry<Item, Integer> entry = new AbstractMap.SimpleEntry<Item, Integer>(stack.getItem(), stack.getMetadata());
                        if (hasAlready.contains(entry)) {
                            iter.remove();
                            continue;
                        }
                        hasAlready.add(entry);
                    }
                }
                if (wrapper instanceof IShapedCraftingRecipeWrapper) {
                    this.craftingRecipeEntries.add(new CraftingRecipeEntry(inputs, output, ((IShapedCraftingRecipeWrapper)wrapper).getWidth(), ((IShapedCraftingRecipeWrapper)wrapper).getHeight(), wrap.getRegistryName() == null ? "noname" : wrap.getRegistryName().toString()));
                    continue;
                }
                this.craftingRecipeEntries.add(new CraftingRecipeEntry(inputs, output, wrap.getRegistryName() == null ? "noname" : wrap.getRegistryName().toString()));
            }
        }
    }

    public void dumpRecipes() {
        for (CraftingRecipeEntry entry : this.craftingRecipeEntries) {
            String s = entry.toString();
            CraftTweakerAPI.logInfo((String)s);
        }
    }

    public class CraftingRecipeEntry {
        List<List<ItemStack>> inputs;
        ItemStack output;
        int width;
        int height;
        boolean shapedRecipe;
        String recipeName;
        int recipeSize;

        CraftingRecipeEntry(List<List<ItemStack>> inputs, ItemStack output, int width, int height, String recipeName) {
            this.inputs = inputs;
            this.output = output;
            this.width = width;
            this.height = height;
            this.recipeName = recipeName;
            this.recipeSize = inputs.size();
            this.shapedRecipe = true;
        }

        CraftingRecipeEntry(List<List<ItemStack>> inputs, ItemStack output, String recipeName) {
            this.inputs = inputs;
            this.output = output;
            this.recipeName = recipeName;
            this.recipeSize = inputs.size();
            this.shapedRecipe = false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.shapedRecipe ? "(shaped)" : "(shapeless)");
            sb.append(this.output.toString());
            sb.append(" > ");
            int i = 0;
            for (List<ItemStack> list : this.inputs) {
                sb.append("\nList ").append(i++).append(" ").append("[").append(list.size()).append("]: ");
                for (ItemStack stack : list) {
                    sb.append(stack.toString()).append(" | ");
                }
            }
            return sb.toString();
        }

        void checkAllConflicting(List<Map.Entry<CraftingRecipeEntry, CraftingRecipeEntry>> entryList) {
            Range range = (Range)ConflictCommand.this.rangeMap.get(this.recipeSize);
            UnmodifiableIterator unmodifiableIterator = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.integers()).iterator();
            while (unmodifiableIterator.hasNext()) {
                int index = (Integer)unmodifiableIterator.next();
                CraftingRecipeEntry otherEntry = (CraftingRecipeEntry)ConflictCommand.this.craftingRecipeEntries.get(index);
                if (otherEntry == this || !this.checkConflict(otherEntry) || entryList.contains(new AbstractMap.SimpleEntry<CraftingRecipeEntry, CraftingRecipeEntry>(this, otherEntry)) || entryList.contains(new AbstractMap.SimpleEntry<CraftingRecipeEntry, CraftingRecipeEntry>(otherEntry, this))) continue;
                entryList.add(new AbstractMap.SimpleEntry<CraftingRecipeEntry, CraftingRecipeEntry>(this, otherEntry));
            }
        }

        boolean checkConflict(CraftingRecipeEntry other) {
            if (this.shapedRecipe && other.shapedRecipe) {
                return this.checkShapedShaped(other);
            }
            if (!this.shapedRecipe && !other.shapedRecipe) {
                return this.checkShapelessShapeless(other);
            }
            return this.shapedRecipe && this.checkShapedShapeless(other);
        }

        boolean checkForEmptySlots(List<ItemStack> inputThis, List<ItemStack> inputOther) {
            if (inputThis.isEmpty() && inputOther.isEmpty()) {
                return true;
            }
            if (inputThis.size() == 1 && inputOther.size() == 1 && inputThis.get(0).isEmpty() && inputOther.get(0).isEmpty()) {
                return true;
            }
            if (inputThis.isEmpty() && inputOther.size() == 1 && inputOther.get(0).isEmpty()) {
                return true;
            }
            if (inputOther.isEmpty() && inputThis.size() == 1) {
                return inputThis.get(0).isEmpty();
            }
            return false;
        }

        boolean checkShapedShaped(CraftingRecipeEntry other) {
            int overlapping = 0;
            if (this.width == other.width && this.height == other.height) {
                for (int i = 0; i < this.recipeSize && overlapping == i; ++i) {
                    List<ItemStack> inputOther;
                    List<ItemStack> inputThis = this.inputs.get(i);
                    if (this.checkForEmptySlots(inputThis, inputOther = other.inputs.get(i))) {
                        ++overlapping;
                        continue;
                    }
                    if (!this.checkConflictingItemStacks(inputThis, inputOther)) continue;
                    ++overlapping;
                }
            } else {
                return false;
            }
            return overlapping == this.recipeSize && !this.compareItemStack(this.output, other.output);
        }

        boolean checkConflictingItemStacks(List<ItemStack> stackListThis, List<ItemStack> stackListOther) {
            boolean hasOneConflict = false;
            for (ItemStack stackListThi : stackListThis) {
                for (ItemStack aStackListOther : stackListOther) {
                    if (!this.compareItemStack(stackListThi, aStackListOther)) continue;
                    hasOneConflict = true;
                }
            }
            return hasOneConflict;
        }

        boolean checkShapelessShapeless(CraftingRecipeEntry other) {
            int overlapping = 0;
            if (this.recipeSize == other.recipeSize) {
                for (int i = 0; i < this.recipeSize && overlapping == i; ++i) {
                    List<ItemStack> inputThis = this.inputs.get(i);
                    List<ItemStack> inputOther = other.inputs.get(i);
                    boolean hasOneConflict = false;
                    for (ItemStack stack : inputThis) {
                        for (ItemStack otherStack : inputOther) {
                            if (!this.compareItemStack(stack, otherStack)) continue;
                            hasOneConflict = true;
                        }
                    }
                    if (!hasOneConflict) continue;
                    ++overlapping;
                }
            } else {
                return false;
            }
            return overlapping == this.recipeSize && !this.compareItemStack(this.output, other.output);
        }

        boolean checkShapedShapeless(CraftingRecipeEntry other) {
            int overlapping = 0;
            if (this.recipeSize == 9 && other.recipeSize == 9) {
                for (int i = 0; i < this.recipeSize && overlapping == i; ++i) {
                    List<ItemStack> inputThis = this.inputs.get(i);
                    List<ItemStack> inputOther = other.inputs.get(i);
                    if (inputThis.isEmpty()) continue;
                    boolean hasOneConflict = false;
                    for (ItemStack stack : inputThis) {
                        for (ItemStack otherStack : inputOther) {
                            if (!this.compareItemStack(stack, otherStack)) continue;
                            hasOneConflict = true;
                        }
                    }
                    if (!hasOneConflict) continue;
                    ++overlapping;
                }
            }
            return overlapping == this.recipeSize && !this.compareItemStack(this.output, other.output);
        }

        boolean compareItemStack(ItemStack stack1, ItemStack stack2) {
            if (stack1 == null || stack2 == null || stack1.isEmpty() || stack2.isEmpty()) {
                return false;
            }
            boolean itemsAreSame = stack1.getItem() == stack2.getItem() && stack1.getMetadata() == stack2.getMetadata();
            return itemsAreSame && Objects.equals(stack1.getTagCompound(), stack2.getTagCompound());
        }

        public boolean equals(Object obj) {
            return obj instanceof CraftingRecipeEntry && this.inputs.equals(((CraftingRecipeEntry)obj).inputs) && this.output.equals(((CraftingRecipeEntry)obj).output) && this.width == ((CraftingRecipeEntry)obj).width && this.height == ((CraftingRecipeEntry)obj).height && this.shapedRecipe == ((CraftingRecipeEntry)obj).shapedRecipe && this.recipeName.equals(((CraftingRecipeEntry)obj).recipeName) && this.recipeSize == ((CraftingRecipeEntry)obj).recipeSize;
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.inputs, this.output, this.recipeName, this.recipeSize, this.shapedRecipe});
        }
    }

    private static class CraftRecipeEntryComparator
    implements Comparator<CraftingRecipeEntry>,
    Serializable {
        private static final long serialVersionUID = 9061636968374415469L;

        private CraftRecipeEntryComparator() {
        }

        @Override
        public int compare(CraftingRecipeEntry o1, CraftingRecipeEntry o2) {
            return Integer.compare(o1.recipeSize, o2.recipeSize);
        }
    }
}

