/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.socket;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.socket.JsonMessageHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class CrTWebSocketHandler
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            CraftTweakerAPI.logInfo((String)"This is a WebSocket frame");
            CraftTweakerAPI.logInfo((String)("Client Channel : " + ctx.channel()));
            if (msg instanceof BinaryWebSocketFrame) {
                CraftTweakerAPI.logInfo((String)"BinaryWebSocketFrame Received : ");
                CraftTweakerAPI.logInfo((String)String.valueOf(((BinaryWebSocketFrame)msg).content()));
            } else if (msg instanceof TextWebSocketFrame) {
                CraftTweakerAPI.logInfo((String)"TextWebSocketFrame Received : ");
                String text = ((TextWebSocketFrame)msg).text();
                if (!text.startsWith("{")) {
                    CraftTweakerAPI.logInfo((String)("No valid json request: " + text));
                    return;
                }
                TextWebSocketFrame res = new TextWebSocketFrame(JsonMessageHandler.handleJson(text, ctx));
                ctx.channel().writeAndFlush((Object)res);
                CraftTweakerAPI.logInfo((String)((TextWebSocketFrame)msg).text());
            } else if (msg instanceof PingWebSocketFrame) {
                CraftTweakerAPI.logInfo((String)"PingWebSocketFrame Received : ");
                CraftTweakerAPI.logInfo((String)String.valueOf(((PingWebSocketFrame)msg).content()));
            } else if (msg instanceof PongWebSocketFrame) {
                CraftTweakerAPI.logInfo((String)"PongWebSocketFrame Received : ");
                CraftTweakerAPI.logInfo((String)String.valueOf(((PongWebSocketFrame)msg).content()));
            } else if (msg instanceof CloseWebSocketFrame) {
                CraftTweakerAPI.logInfo((String)"CloseWebSocketFrame Received : ");
                CraftTweakerAPI.logInfo((String)("ReasonText :" + ((CloseWebSocketFrame)msg).reasonText()));
                CraftTweakerAPI.logInfo((String)("StatusCode : " + ((CloseWebSocketFrame)msg).statusCode()));
            } else {
                CraftTweakerAPI.logWarning((String)"Unsupported WebSocketFrame");
            }
        }
    }
}

