/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.entity;

import crafttweaker.api.damage.IDamageSource;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.entity.attribute.IEntityAttributeInstance;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.mc1120.entity.MCEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class MCEntityLivingBase
extends MCEntity
implements IEntityLivingBase {
    private final EntityLivingBase entityLivingBase;

    public MCEntityLivingBase(EntityLivingBase entity) {
        super((Entity)entity);
        this.entityLivingBase = entity;
    }

    public boolean canBreatheUnderwater() {
        return this.entityLivingBase.func_70648_aU();
    }

    public boolean isPotionActive(IPotion potion) {
        return this.entityLivingBase.func_70644_a(CraftTweakerMC.getPotion(potion));
    }

    public float getHealth() {
        return this.entityLivingBase.func_110143_aJ();
    }

    public void setHealth(float amount) {
        this.entityLivingBase.func_70606_j(amount);
    }

    public boolean isChild() {
        return this.entityLivingBase.func_70631_g_();
    }

    public void clearActivePotions() {
        this.entityLivingBase.func_70674_bp();
    }

    public boolean isUndead() {
        return this.entityLivingBase.func_70662_br();
    }

    public void heal(float amount) {
        this.entityLivingBase.func_70691_i(amount);
    }

    public float getMaxHealth() {
        return this.entityLivingBase.func_110138_aP();
    }

    public IItemStack getHeldItemMainHand() {
        return CraftTweakerMC.getIItemStack(this.entityLivingBase.func_184614_ca());
    }

    public IItemStack getHeldItemOffHand() {
        return CraftTweakerMC.getIItemStack(this.entityLivingBase.func_184592_cb());
    }

    public IEntityAttributeInstance getAttribute(String name) {
        return CraftTweakerMC.getAttributeInstance(this.entityLivingBase.func_110140_aT().func_111152_a(name));
    }

    public IEntityLivingBase getRevengeTarget() {
        return CraftTweakerMC.getIEntityLivingBase(this.entityLivingBase.func_70643_av());
    }

    public void setRevengeTarger(IEntityLivingBase target) {
        this.entityLivingBase.func_70604_c(CraftTweakerMC.getEntityLivingBase(target));
    }

    public IEntityLivingBase getLastAttackedEntity() {
        return CraftTweakerMC.getIEntityLivingBase(this.entityLivingBase.func_110144_aD());
    }

    public void setLastAttackedEntity(IEntityLivingBase entity) {
        this.entityLivingBase.func_130011_c((Entity)CraftTweakerMC.getEntityLivingBase(entity));
    }

    public int getLastAttackedEntityTime() {
        return this.entityLivingBase.func_142013_aG();
    }

    public List<IPotionEffect> getActivePotionEffects() {
        return this.entityLivingBase.func_70651_bq().stream().map(CraftTweakerMC::getIPotionEffect).collect(Collectors.toList());
    }

    public IPotionEffect getActivePotionEffect(IPotion potion) {
        return CraftTweakerMC.getIPotionEffect(this.entityLivingBase.func_70660_b(CraftTweakerMC.getPotion(potion)));
    }

    public boolean isPotionEffectApplicable(IPotionEffect potionEffect) {
        return this.entityLivingBase.func_70687_e(CraftTweakerMC.getPotionEffect(potionEffect));
    }

    public IDamageSource getLastDamageSource() {
        return CraftTweakerMC.getIDamageSource(this.entityLivingBase.func_189748_bU());
    }

    public void onDeath(IDamageSource source) {
        this.entityLivingBase.func_70645_a(CraftTweakerMC.getDamageSource(source));
    }

    public void knockBack(IEntity entity, float strength, double xRatio, double zRatio) {
        this.entityLivingBase.func_70653_a(CraftTweakerMC.getEntity(entity), strength, xRatio, zRatio);
    }

    public boolean isOnLadder() {
        return this.entityLivingBase.func_70617_f_();
    }

    public int getTotalArmorValue() {
        return this.entityLivingBase.func_70658_aO();
    }

    public IEntityLivingBase getAttackingEntity() {
        return CraftTweakerMC.getIEntityLivingBase(this.entityLivingBase.func_94060_bK());
    }

    public int getArrowCountInEntity() {
        return this.entityLivingBase.func_85035_bI();
    }

    public void setArrowCountInEntity(int arrows) {
        this.entityLivingBase.func_85034_r(arrows);
    }

    public float getAIMoveSpeed() {
        return this.entityLivingBase.func_70689_ay();
    }

    public void setAIMoveSpeed(float speed) {
        this.entityLivingBase.func_70659_e(speed);
    }

    public void onLivingUpdate() {
        this.entityLivingBase.func_70636_d();
    }

    public boolean canEntityBeSeen(IEntity other) {
        return this.entityLivingBase.func_70685_l(CraftTweakerMC.getEntity(other));
    }

    public void addPotionEffect(IPotionEffect potionEffect) {
        this.entityLivingBase.func_70690_d(CraftTweakerMC.getPotionEffect(potionEffect));
    }

    public void setItemToSlot(IEntityEquipmentSlot slot, IItemStack itemStack) {
        this.entityLivingBase.func_184201_a(CraftTweakerMC.getEntityEquipmentSlot(slot), CraftTweakerMC.getItemStack(itemStack));
    }

    public boolean hasItemInSlot(IEntityEquipmentSlot slot) {
        return this.entityLivingBase.func_190630_a(CraftTweakerMC.getEntityEquipmentSlot(slot));
    }

    public IItemStack getItemInSlot(IEntityEquipmentSlot slot) {
        return CraftTweakerMC.getIItemStack(this.entityLivingBase.func_184582_a(CraftTweakerMC.getEntityEquipmentSlot(slot)));
    }
}

