package crafttweaker.mc1120.text.expand;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethodStatic;

/**
 * @author youyihj
 */
@ZenRegister
@ZenExpansion("crafttweaker.text.ITextComponent")
public class ExpandTextComponent {
    @ZenMethodStatic
    public static ITextComponent fromString(String s) {
        return CraftTweakerMC.getITextComponent(new TextComponentString(s));
    }

    @ZenMethodStatic
    public static ITextComponent fromTranslation(String translationKey) {
        return CraftTweakerMC.getITextComponent(new TextComponentTranslation(translationKey));
    }

    @ZenMethodStatic
    public static ITextComponent fromTranslation(String translationKey, Object... args) {
        Object[] actualArgs = new Object[args.length];
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            actualArgs[i] = arg instanceof ITextComponent ? CraftTweakerMC.getITextComponent(((ITextComponent) arg)) : arg;
        }
        return CraftTweakerMC.getITextComponent(new TextComponentTranslation(translationKey, actualArgs));
    }

    @ZenMethodStatic
    public static ITextComponent fromData(IData data) {
        if (data instanceof DataMap || data instanceof DataList) {
            return CraftTweakerMC.getITextComponent(net.minecraft.util.text.ITextComponent.Serializer.fromJsonLenient(data.asString()));
        } else {
            throw new IllegalArgumentException("data argument must be DataMap or DataList!");
        }
    }
}
