/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.entity.attribute.IEntityAttributeModifier;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IMutableItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.data.NBTUpdater;
import java.util.HashMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="crafttweaker.item.IItemStack")
@ZenRegister
public class ExpandItemStack {
    private static ItemStack getInternal(IItemStack expanded) {
        if (expanded instanceof IMutableItemStack) {
            return CraftTweakerMC.getItemStack((IMutableItemStack)expanded);
        }
        return CraftTweakerMC.getItemStack(expanded);
    }

    @ZenMethod
    @ZenGetter(value="isBlock")
    public static boolean isBlock(IItemStack value) {
        return ExpandItemStack.getInternal(value).getItem() instanceof ItemBlock;
    }

    @ZenMethod
    public static void addAttributeModifier(IItemStack stack, String attributeName, IEntityAttributeModifier modifier, IEntityEquipmentSlot equipmentSlot) {
        ExpandItemStack.getInternal(stack).addAttributeModifier(attributeName, CraftTweakerMC.getAttributeModifier(modifier), CraftTweakerMC.getEntityEquipmentSlot(equipmentSlot));
    }

    @ZenGetter(value="maxItemUseDuration")
    @ZenMethod
    public static int getMaxItemUseDuration(IItemStack stack) {
        return ExpandItemStack.getInternal(stack).getMaxItemUseDuration();
    }

    @ZenGetter(value="capNBT")
    @ZenMethod
    public static IData getCapNBT(IItemStack stack) {
        return CraftTweakerMC.getIData((NBTBase)CraftTweakerMC.getItemStack(stack).serializeNBT().getCompoundTag("ForgeCaps"));
    }

    @ZenMethod
    public static IItemStack withCapNBT(IItemStack stack, IData capNBT) {
        if (stack instanceof IMutableItemStack) {
            ItemStack vanillaStack = ExpandItemStack.getInternal(stack);
            HashMap<String, IData> dataTemp = new HashMap<String, IData>();
            dataTemp.put("ForgeCaps", capNBT);
            NBTTagCompound nbt = vanillaStack.serializeNBT();
            NBTUpdater.updateMap(nbt, (IData)new DataMap(dataTemp, true));
            vanillaStack.deserializeNBT(nbt);
            return stack;
        }
        return CraftTweakerMC.getIItemStack(new ItemStack(CraftTweakerMC.getItem(stack.getDefinition()), stack.getAmount(), stack.getMetadata(), (NBTTagCompound)NBTConverter.from(capNBT))).withTag(stack.getTag(), stack.getMatchTagExact());
    }
}

