/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.ItemStackUnknown;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.api.recipes.ICraftingInfo;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.mc1120.recipes.MCCraftingInventorySquared;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import java.util.HashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class MCRecipeShapeless
extends MCRecipeBase {
    private final IIngredient[] ingredients;

    public MCRecipeShapeless(IIngredient[] ingredients, IItemStack output, IRecipeFunction recipeFunction, IRecipeAction recipeAction, boolean isHidden) {
        super(output, MCRecipeShapeless.createIngredientList(ingredients), recipeFunction, recipeAction, isHidden);
        this.ingredients = ingredients;
    }

    private static NonNullList<Ingredient> createIngredientList(IIngredient[] ingredients) {
        NonNullList ingredientList = NonNullList.func_191197_a((int)ingredients.length, (Object)Ingredient.field_193370_a);
        for (int index = 0; index < ingredients.length; ++index) {
            IIngredient ingredient = ingredients[index];
            if (ingredient == null) continue;
            ingredientList.set(index, (Object)CraftTweakerMC.getIngredient(ingredients[index]));
        }
        return ingredientList;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        boolean[] visited = new boolean[inv.func_70302_i_()];
        boolean matches = true;
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (visited[slot] || stackInSlot.func_190926_b() || !ingredient.matches(CraftTweakerMC.getIItemStackForMatching(stackInSlot))) continue;
                visited[slot] = true;
                continue block0;
            }
            matches = false;
        }
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot] || inv.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return matches;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.recipeFunction == null) {
            return this.outputStack.func_77946_l();
        }
        HashMap<String, IItemStack> marks = new HashMap<String, IItemStack>();
        boolean[] visited = new boolean[inv.func_70302_i_()];
        block2: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            if (ingredient == null || ingredient.getMark() == null) continue;
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                IItemStack stack;
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (stackInSlot.func_190926_b() || visited[slot] || !ingredient.matches(stack = CraftTweakerMC.getIItemStack(stackInSlot))) continue;
                marks.put(ingredient.getMark(), stack);
                visited[slot] = true;
                continue block2;
            }
        }
        IItemStack out = null;
        try {
            out = this.recipeFunction.process(this.output, marks, (ICraftingInfo)new CraftingInfo((ICraftingInventory)new MCCraftingInventorySquared((IInventory)inv), null));
        }
        catch (Exception exception) {
            CraftTweakerAPI.logError((String)"Could not execute RecipeFunction: ", (Throwable)exception);
        }
        return CraftTweakerMC.getItemStack(out);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.length;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList out = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean[] visited = new boolean[inv.func_70302_i_()];
        block2: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                IItemStack stack;
                IIngredient ingredient;
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (stackInSlot.func_190926_b() || visited[slot] || !(ingredient = this.ingredients[ingredientIndex]).matches(stack = CraftTweakerMC.getIItemStack(stackInSlot))) continue;
                boolean needsContainerItem = true;
                if (ingredient.hasNewTransformers()) {
                    IItemStack remainingItem = null;
                    try {
                        remainingItem = ingredient.applyNewTransform(stack);
                    }
                    catch (Exception exception) {
                        CraftTweakerAPI.logError((String)("Could not execute NewRecipeTransformer on " + ingredient.toCommandString() + ":"), (Throwable)exception);
                    }
                    if (remainingItem != ItemStackUnknown.INSTANCE) {
                        out.set(slot, (Object)CraftTweakerMC.getItemStack(remainingItem));
                        needsContainerItem = false;
                    }
                }
                if (ingredient.hasTransformers()) {
                    stackInSlot.func_190920_e(stackInSlot.func_190916_E() + 1);
                    needsContainerItem = false;
                }
                if (needsContainerItem) {
                    out.set(slot, (Object)ForgeHooks.getContainerItem((ItemStack)stackInSlot));
                }
                visited[slot] = true;
                continue block2;
            }
        }
        return out;
    }

    public String toCommandString() {
        StringBuilder commandString = new StringBuilder("recipes.add");
        commandString.append(this.hidden ? "Hidden" : "");
        commandString.append("Shapeless(\"");
        commandString.append(this.getName()).append("\", ");
        commandString.append(this.output.toString()).append(", [");
        if (this.ingredients.length > 0) {
            for (IIngredient ingredient : this.ingredients) {
                commandString.append(ingredient.toCommandString()).append(", ");
            }
            commandString.deleteCharAt(commandString.length() - 1);
            commandString.deleteCharAt(commandString.length() - 1);
        }
        commandString.append("]);");
        return commandString.toString();
    }

    public boolean hasTransformers() {
        for (IIngredient ingredient : this.ingredients) {
            if (ingredient == null || !ingredient.hasTransformers()) continue;
            return true;
        }
        return false;
    }

    public IIngredient[] getIngredients1D() {
        return this.ingredients;
    }

    public IIngredient[][] getIngredients2D() {
        return new IIngredient[][]{this.ingredients};
    }

    public boolean isShaped() {
        return false;
    }

    @Override
    public void applyTransformers(InventoryCrafting inventory, IPlayer byPlayer) {
        boolean[] visited = new boolean[inventory.func_70302_i_()];
        block2: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                IItemStack stack;
                ItemStack stackInSlot = inventory.func_70301_a(slot);
                if (stackInSlot.func_190926_b() || visited[slot] || !ingredient.matches(stack = CraftTweakerMC.getIItemStack(stackInSlot))) continue;
                IItemStack out = null;
                try {
                    out = ingredient.applyTransform(stack, byPlayer);
                }
                catch (Exception exception) {
                    CraftTweakerAPI.logError((String)("Could not execute RecipeTransformer on " + ingredient.toCommandString() + ":"), (Throwable)exception);
                }
                inventory.func_70299_a(slot, CraftTweakerMC.getItemStack(out));
                visited[slot] = true;
                continue block2;
            }
        }
    }

    @Override
    public MCRecipeShapeless update() {
        this.ingredientList = MCRecipeShapeless.createIngredientList(this.ingredients);
        return this;
    }
}

