/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.block.IBlock;
import crafttweaker.api.event.BlockHarvestDropsEvent;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.events.handling.MCBlockEvent;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.BlockEvent;

public class MCBlockHarvestDropsEvent
extends MCBlockEvent
implements BlockHarvestDropsEvent {
    private final BlockEvent.HarvestDropsEvent event;

    public MCBlockHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        super((BlockEvent)event);
        this.event = event;
    }

    public float getDropChance() {
        return this.event.getDropChance();
    }

    public void setDropChance(float dropChance) {
        this.event.setDropChance(dropChance);
    }

    public int getFortuneLevel() {
        return this.event.getFortuneLevel();
    }

    public IBlock getBlock() {
        return this.getBlockState().getBlock();
    }

    public List<WeightedItemStack> getDrops() {
        return CraftTweakerMC.getWeightedItemStackList(this.event.getDrops());
    }

    public void setDrops(List<WeightedItemStack> drops) {
        this.event.getDrops().clear();
        for (WeightedItemStack drop : drops) {
            this.addItem(drop);
        }
    }

    public void addItem(WeightedItemStack itemStack) {
        if (this.event.getWorld().field_73012_v.nextFloat() <= itemStack.getChance()) {
            this.event.getDrops().add(CraftTweakerMC.getItemStack(itemStack.getStack()));
        }
    }

    public boolean isSilkTouch() {
        return this.event.isSilkTouching();
    }

    public boolean isPlayer() {
        return this.event.getHarvester() instanceof EntityPlayerMP || this.event.getHarvester() instanceof EntityPlayerSP;
    }

    public IPlayer getPlayer() {
        return CraftTweakerMC.getIPlayer(this.event.getHarvester());
    }
}

