/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBiomeType;
import crafttweaker.mc1120.brackets.BracketHandlerBiomeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MCBiome
implements IBiome {
    private final Biome biome;

    public MCBiome(Biome biome) {
        this.biome = biome;
    }

    public String getId() {
        return this.biome.getRegistryName().toString();
    }

    public String getName() {
        return this.biome.biomeName;
    }

    public boolean getCanRain() {
        return this.biome.canRain();
    }

    public boolean isSnowyBiome() {
        return this.biome.isSnowyBiome();
    }

    public boolean getIsHighHumidity() {
        return this.biome.isHighHumidity();
    }

    public float getSpawningChance() {
        return this.biome.getSpawningChance();
    }

    public float getBaseHeight() {
        return this.biome.getBaseHeight();
    }

    public float getRainfall() {
        return this.biome.getRainfall();
    }

    public int getWaterColorMultiplier() {
        return this.biome.getWaterColorMultiplier();
    }

    public boolean getIgnorePlayerSpawnSuitability() {
        return this.biome.ignorePlayerSpawnSuitability();
    }

    public float getHeightVariation() {
        return this.biome.getHeightVariation();
    }

    public float getTemperature() {
        return this.biome.getDefaultTemperature();
    }

    public List<IBiomeType> getTypes() {
        ArrayList<IBiomeType> types = new ArrayList<IBiomeType>();
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)this.biome)) {
            types.add(BracketHandlerBiomeType.getBiomeType(type.getName()));
        }
        return types;
    }

    public Biome getInternal() {
        return this.biome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCBiome mcBiome = (MCBiome)o;
        return Objects.equals(this.biome, mcBiome.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

