/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands.dumpzscommand;

import crafttweaker.annotations.ZenDoc;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.commands.dumpzscommand.DumpZsTarget;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import stanhebben.zenscript.dump.TreeNode;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.Pair;

public class TargetHtml
extends DumpZsTarget {
    private static final String HTML_HEADER = "<!DOCTYPE html>\n<head><link rel=\"stylesheet\" href=\"tree3.css\"> <title>CraftTweaker: ZenScript Language Dump</title></head>";
    private static final String HTML_BODY_START = "<p>CraftTweaker ZenScript language, refer to <a href=\"http://crafttweaker.readthedocs.io/\" target=\"_blank\">this page</a> for more help.</p>";
    private static final String HTML_DIV_START = "<div class=\"css-treeview\"><ul>";
    private static final String HTML_DIV_END = "</ul></div>";
    private static final String HTML_BODY_END = "<p>This File was created using the dumpzs command.</p>";
    private static final Comparator<TreeNode<String>> STRING_TREE_COMPARATOR = (o1, o2) -> ((String)o1.data).compareToIgnoreCase((String)o2.data);
    private int itemCounter = 0;

    public TargetHtml() {
        super("html");
    }

    @Override
    public String getDescription() {
        return "Dumps to a local HTML file";
    }

    @Override
    public void execute(ICommandSender sender, MinecraftServer Server) {
        TreeNode root = new TreeNode((Object)"root");
        File zsDataFolder = new File("crafttweaker_dump");
        if (!zsDataFolder.exists()) {
            zsDataFolder.mkdirs();
        }
        URL inputUrlPNG = this.getClass().getResource("/assets/crafttweaker/icons.png");
        try {
            FileUtils.copyURLToFile((URL)inputUrlPNG, (File)new File(zsDataFolder, "icons.png"));
        }
        catch (IOException e) {
            CraftTweaker.LOG.catching((Throwable)e);
        }
        URL inputUrlCSS = this.getClass().getResource("/assets/crafttweaker/tree3.css");
        try {
            FileUtils.copyURLToFile((URL)inputUrlCSS, (File)new File(zsDataFolder, "tree3.css"));
        }
        catch (IOException e) {
            CraftTweaker.LOG.catching((Throwable)e);
        }
        TreeNode bracketNode = root.addChild((Object)"Bracket Handlers");
        for (Pair pair : GlobalRegistry.getPrioritizedBracketHandlers()) {
            bracketNode.addChild((Object)(((IBracketHandler)pair.getValue()).getClass().getName() + ", priority: " + pair.getKey()));
        }
        TreeNode types = root.addChild((Object)"Types");
        GlobalRegistry.getTypes().getTypeMap().forEach((aClass, zenType) -> {
            TreeNode zsType = types.addChild((Object)zenType.getName());
            zsType.addChild((Object)aClass.getName());
        });
        types.children.sort(STRING_TREE_COMPARATOR);
        TreeNode globals = root.addChild((Object)"Globals");
        GlobalRegistry.getGlobals().forEach((s, iZenSymbol) -> {
            TreeNode globalName = globals.addChild(s);
            globalName.addChild((Object)iZenSymbol.toString());
        });
        globals.children.sort(STRING_TREE_COMPARATOR);
        TreeNode expansions = root.addChild((Object)"Expansions");
        GlobalRegistry.getExpansions().forEach((s, typeExpansion) -> {
            TreeNode exp = expansions.addChild(s);
            exp.addChild((Object)typeExpansion.getClass().getName());
        });
        expansions.children.sort(STRING_TREE_COMPARATOR);
        TreeNode symbols = root.addChild((Object)"Root (Symbol Package)");
        GlobalRegistry.getRoot().getPackages().forEach((s, zenSymbol) -> this.printZenSymbol((String)s, (IZenSymbol)zenSymbol, (TreeNode<String>)symbols));
        this.sortTreeNodes((TreeNode<String>)symbols);
        try {
            List<String> lines = Arrays.asList(HTML_HEADER, HTML_BODY_START, HTML_DIV_START, this.convertToFlatHTMLStrings((TreeNode<String>)root), HTML_DIV_END, HTML_BODY_END);
            Path file = Paths.get(zsDataFolder.getAbsolutePath() + "/tree3.html", new String[0]);
            Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            CraftTweaker.LOG.catching((Throwable)e);
        }
        sender.sendMessage(SpecialMessagesChat.getFileOpenText("Dumped content of the GlobalRegistry to a html file \u00a7r[\u00a76Click here to open\u00a7r]", zsDataFolder.getAbsolutePath() + "/tree3.html"));
    }

    private void sortTreeNodes(TreeNode<String> parentNode) {
        if (parentNode.isLeaf()) {
            return;
        }
        parentNode.children.sort(STRING_TREE_COMPARATOR);
        for (TreeNode child : parentNode.children) {
            this.sortTreeNodes((TreeNode<String>)child);
        }
    }

    private String convertToFlatHTMLStrings(TreeNode<String> root) {
        this.itemCounter = 0;
        StringBuilder sb = new StringBuilder();
        for (TreeNode child : root.children) {
            sb.append(this.createListBodyString((TreeNode<String>)child));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String createListBodyString(TreeNode<String> node) {
        if (node.isLeaf()) {
            return this.createLeaveString(node);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<li><input type=\"checkbox\" id=\"item-").append(this.itemCounter).append("\" /><label for=\"item-").append(this.itemCounter).append("\">").append((String)node.data).append("</label><ul>");
        ++this.itemCounter;
        for (TreeNode child : node.children) {
            sb.append(this.createListBodyString((TreeNode<String>)child));
        }
        sb.append("</ul></li>");
        return sb.toString();
    }

    private String createLeaveString(TreeNode<String> node) {
        if (node.isLeaf()) {
            return "<li>" + (String)node.data + "</li>";
        }
        return "";
    }

    private void printZenSymbol(String s, IZenSymbol zenSymbol, TreeNode<String> node) {
        if (zenSymbol instanceof SymbolPackage) {
            this.printZenSymbolHelper(zenSymbol, node);
        } else {
            TreeNode n = node.addChild((Object)s);
            n.addChild((Object)zenSymbol.toString());
        }
    }

    private void printZenSymbolHelper(IZenSymbol zenSymbol, TreeNode<String> node) {
        if (zenSymbol instanceof SymbolPackage) {
            SymbolPackage symbolPackage = (SymbolPackage)zenSymbol;
            symbolPackage.getPackages().forEach((s1, symbol) -> {
                TreeNode<String> childNode = this.addToTree((IZenSymbol)symbol, node);
                this.printZenSymbolHelper((IZenSymbol)symbol, childNode);
            });
        } else if (zenSymbol instanceof SymbolType || zenSymbol instanceof ZenTypeNative) {
            ZenTypeNative typeNative = null;
            if (zenSymbol instanceof SymbolType) {
                ZenType type = ((SymbolType)zenSymbol).getType();
                if (type instanceof ZenTypeNative) {
                    typeNative = (ZenTypeNative)type;
                }
            } else {
                typeNative = (ZenTypeNative)zenSymbol;
            }
            if (typeNative != null) {
                this.addTypeNativeToTree(typeNative, node);
            }
        }
    }

    public void addTypeNativeToTree(ZenTypeNative typeNative, TreeNode<String> node) {
        typeNative.getMembers().forEach((s, zenNativeMember) -> {
            TreeNode n;
            TreeNode chNode = node.addChild(s);
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                TreeNode n2 = chNode.addChild((Object)"Java Method");
                n2.addChild((Object)this.methodToString(iJavaMethod));
            }
            if (zenNativeMember.getGetter() != null) {
                n = chNode.addChild((Object)"Getter");
                n.addChild((Object)this.methodToString(zenNativeMember.getGetter()));
            }
            if (zenNativeMember.getSetter() != null) {
                n = chNode.addChild((Object)"Setter");
                n.addChild((Object)this.methodToString(zenNativeMember.getSetter()));
            }
        });
        typeNative.getStaticMembers().forEach((s, zenNativeMember) -> {
            TreeNode n;
            TreeNode chNode = node.addChild((Object)("[STATIC] " + s));
            for (IJavaMethod iJavaMethod : zenNativeMember.getMethods()) {
                TreeNode n2 = chNode.addChild((Object)"Java Method");
                n2.addChild((Object)this.methodToString(iJavaMethod));
            }
            if (zenNativeMember.getGetter() != null) {
                n = chNode.addChild((Object)"Getter");
                n.addChild((Object)this.methodToString(zenNativeMember.getGetter()));
            }
            if (zenNativeMember.getSetter() != null) {
                n = chNode.addChild((Object)"Setter");
                n.addChild((Object)this.methodToString(zenNativeMember.getSetter()));
            }
        });
    }

    private String methodToString(IJavaMethod javaMethod) {
        if (javaMethod == null) {
            return "";
        }
        if (javaMethod instanceof JavaMethod) {
            Method jm = ((JavaMethod)javaMethod).getMethod();
            StringBuilder sb = new StringBuilder();
            ZenDoc[] doc = (ZenDoc[])jm.getAnnotationsByType(ZenDoc.class);
            if (doc.length > 0) {
                sb.append(this.encaplseInSpan("########", "green"));
                for (ZenDoc zenDoc : doc) {
                    sb.append("<br/>");
                    sb.append(this.encaplseInSpan(zenDoc.value(), "green"));
                }
                sb.append(this.encaplseInSpan("<br/>########<br/>", "green"));
            }
            sb.append(Modifier.toString(jm.getModifiers()));
            sb.append(" ");
            sb.append(this.createHoverText(jm.getReturnType().getName(), jm.getReturnType().getSimpleName()));
            sb.append(" ");
            sb.append(this.encaplseInSpan(jm.getName(), "red"));
            sb.append("(");
            Class<?>[] paras = jm.getParameterTypes();
            Annotation[][] annos = jm.getParameterAnnotations();
            for (int i = 0; i < paras.length; ++i) {
                for (int j = 0; j < annos[i].length; ++j) {
                    sb.append(this.encaplseInSpan("@" + annos[i][j].annotationType().getSimpleName() + " ", "gold"));
                }
                sb.append(this.createHoverText(paras[i].getName(), paras[i].getSimpleName()));
                if (i == paras.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        return javaMethod.toString();
    }

    private String colorClassName(String name) {
        int lastDot = name.lastIndexOf(".");
        if (lastDot > 0) {
            return name.substring(0, lastDot + 1) + this.encaplseInSpan(name.substring(lastDot + 1, name.length()), "DarkOrange");
        }
        return this.encaplseInSpan(name, "DarkOrange");
    }

    private String encaplseInSpan(String value, String color) {
        return "<span style=\"color:" + color + "\">" + value + "</span>";
    }

    private String createHoverText(String hoverText, String mainText) {
        return "<span title=\"" + hoverText + "\">" + mainText + "</span>";
    }

    private TreeNode<String> addToTree(IZenSymbol symbol, TreeNode<String> node) {
        String name = symbol instanceof SymbolPackage ? null : (symbol instanceof SymbolType ? ((SymbolType)symbol).getType().getName() : symbol.toString());
        if (name != null) {
            String[] split;
            for (String s : split = name.split("\\.")) {
                TreeNode childNode = node.findTreeNode((Comparable)((Object)s));
                if (childNode == null) {
                    childNode = node.addChild((Object)s);
                }
                node = childNode;
            }
        }
        return node;
    }
}

