/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.actions;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ActionSetBlockHardness
implements IAction {
    private final ItemStack stack;
    private final float hardness;

    public ActionSetBlockHardness(ItemStack stack, float hardness) {
        this.stack = stack;
        this.hardness = hardness;
    }

    private static void set(ItemStack stack, float hardness) {
        if (ActionSetBlockHardness.isBlock(stack)) {
            Block block = Block.getBlockFromItem((Item)stack.getItem());
            block.setHardness(hardness);
        } else {
            CraftTweakerAPI.logError((String)"Item is not a block");
        }
    }

    public static boolean isBlock(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation name = (ResourceLocation)Block.REGISTRY.getNameForObject((Object)Block.getBlockFromItem((Item)stack.getItem()));
        return !name.toString().equals("minecraft:air") && Block.REGISTRY.containsKey((Object)name);
    }

    public void apply() {
        if (ActionSetBlockHardness.isBlock(this.stack)) {
            ActionSetBlockHardness.set(this.stack, this.hardness);
        }
    }

    public String describe() {
        if (ActionSetBlockHardness.isBlock(this.stack)) {
            return "Setting hardness of " + this.stack.getDisplayName() + " to " + this.hardness;
        }
        return "Unable to set hardness of " + this.stack.getDisplayName() + " because it is an Item";
    }
}

