/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.socket.messages;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.runtime.CrTTweaker;
import crafttweaker.socket.SingleError;
import crafttweaker.socket.messages.IRequestMessage;
import crafttweaker.socket.messages.LintResponseMessage;
import crafttweaker.socket.messages.SocketMessage;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;

public class LintRequestMessage
extends SocketMessage<LintRequestMessage>
implements IRequestMessage<LintResponseMessage> {
    public LintRequestMessage() {
        super("LintRequest");
    }

    @Override
    public LintResponseMessage handleReceive(ChannelHandlerContext ctx) {
        CraftTweakerAPI.logInfo((String)"Received a linting request, starting to lint.");
        ArrayList<SingleError> errors = new ArrayList<SingleError>();
        boolean didLoad = this.lint(errors);
        CraftTweakerAPI.logInfo((String)("errors = " + errors));
        return new LintResponseMessage(errors, didLoad);
    }

    private boolean lint(List<SingleError> list) {
        if (!(CraftTweakerAPI.tweaker instanceof CrTTweaker)) {
            CraftTweakerAPI.logError((String)("We currently load with an unsupported loader class: " + CraftTweakerAPI.tweaker.getClass()));
            return false;
        }
        CrTTweaker tweaker = (CrTTweaker)CraftTweakerAPI.tweaker;
        return tweaker.loadScript(true, "NONE", list, true);
    }

    public String toString() {
        return "LintRequestMessage{}";
    }
}

