/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.liquid;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import java.util.Objects;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MCLiquidDefinition
implements ILiquidDefinition {
    private final Fluid fluid;

    public MCLiquidDefinition(Fluid fluid) {
        this.fluid = fluid;
    }

    public String getName() {
        return this.fluid.getName();
    }

    public String getDisplayName() {
        return this.fluid.getLocalizedName(new FluidStack(this.fluid, 1000));
    }

    public ILiquidStack asStack(int millibuckets) {
        return new MCLiquidStack(new FluidStack(this.fluid, millibuckets));
    }

    public int getLuminosity() {
        return this.fluid.getLuminosity();
    }

    public void setLuminosity(int value) {
        CraftTweakerAPI.apply((IAction)new ActionSetLuminosity(value));
    }

    public int getDensity() {
        return this.fluid.getDensity();
    }

    public void setDensity(int density) {
        CraftTweakerAPI.apply((IAction)new ActionSetDensity(density));
    }

    public int getTemperature() {
        return this.fluid.getTemperature();
    }

    public void setTemperature(int temperature) {
        CraftTweakerAPI.apply((IAction)new ActionSetTemperature(temperature));
    }

    public int getViscosity() {
        return this.fluid.getViscosity();
    }

    public void setViscosity(int viscosity) {
        CraftTweakerAPI.apply((IAction)new ActionSetViscosity(viscosity));
    }

    public boolean isGaseous() {
        return this.fluid.isGaseous();
    }

    public void setGaseous(boolean gaseous) {
        CraftTweakerAPI.apply((IAction)new ActionSetGaseous(gaseous));
    }

    public IBlock getBlock() {
        return CraftTweakerMC.getBlock(this.fluid.getBlock(), 0);
    }

    public Fluid getInternal() {
        return this.fluid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCLiquidDefinition that = (MCLiquidDefinition)o;
        return Objects.equals(this.fluid, that.fluid);
    }

    public int hashCode() {
        return Objects.hash(this.fluid);
    }

    private class ActionSetGaseous
    implements IAction {
        private final boolean oldValue;
        private final boolean newValue;

        public ActionSetGaseous(boolean newValue) {
            this.oldValue = MCLiquidDefinition.this.isGaseous();
            this.newValue = newValue;
        }

        public void apply() {
            MCLiquidDefinition.this.fluid.setGaseous(this.newValue);
        }

        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " gaseous from " + this.oldValue + " to " + this.newValue;
        }
    }

    private class ActionSetViscosity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetViscosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getViscosity();
            this.newValue = newValue;
        }

        public void apply() {
            MCLiquidDefinition.this.fluid.setViscosity(this.newValue);
        }

        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " viscosity from " + this.oldValue + " to " + this.newValue;
        }
    }

    private class ActionSetTemperature
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetTemperature(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getTemperature();
            this.newValue = newValue;
        }

        public void apply() {
            MCLiquidDefinition.this.fluid.setTemperature(this.newValue);
        }

        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " temperature from " + this.oldValue + " to " + this.newValue;
        }
    }

    private class ActionSetDensity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetDensity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getDensity();
            this.newValue = newValue;
        }

        public void apply() {
            MCLiquidDefinition.this.fluid.setDensity(this.newValue);
        }

        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " density from " + this.oldValue + " to " + this.newValue;
        }
    }

    private class ActionSetLuminosity
    implements IAction {
        private final int oldValue;
        private final int newValue;

        public ActionSetLuminosity(int newValue) {
            this.oldValue = MCLiquidDefinition.this.getLuminosity();
            this.newValue = newValue;
        }

        public void apply() {
            MCLiquidDefinition.this.fluid.setLuminosity(this.newValue);
        }

        public String describe() {
            return "Setting " + MCLiquidDefinition.this.fluid.getName() + " luminosity from " + this.oldValue + " to " + this.newValue;
        }
    }
}

