/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands.dumpzscommand;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.commands.dumpzscommand.DumpZsTarget;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.util.Pair;

public class TargetLog
extends DumpZsTarget {
    public TargetLog() {
        super("log");
    }

    @Override
    public String getDescription() {
        return "Dumps to the log";
    }

    @Override
    public void execute(ICommandSender sender, MinecraftServer Server) {
        CraftTweakerAPI.logCommand((String)"\nBracket Handlers:");
        for (Pair pair : GlobalRegistry.getPrioritizedBracketHandlers()) {
            CraftTweakerAPI.logCommand((String)(((IBracketHandler)pair.getValue()).getClass().getName() + ", priority: " + pair.getKey()));
        }
        CraftTweakerAPI.logCommand((String)"\nTypes:");
        GlobalRegistry.getTypes().getTypeMap().forEach((aClass, zenType) -> CraftTweakerAPI.logCommand((String)(aClass.getName() + ": " + zenType.getName())));
        CraftTweakerAPI.logCommand((String)"\nGlobals:");
        GlobalRegistry.getGlobals().forEach((s, iZenSymbol) -> CraftTweakerAPI.logCommand((String)(s + ": " + iZenSymbol.toString())));
        CraftTweakerAPI.logCommand((String)"\nExpansions:");
        GlobalRegistry.getExpansions().forEach((s, typeExpansion) -> CraftTweakerAPI.logCommand((String)(s + ": " + typeExpansion.toString())));
        CraftTweakerAPI.logCommand((String)"\nRoot (Symbol Package):");
        GlobalRegistry.getRoot().getPackages().forEach(this::printZenSymbol);
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Dumped content of the GlobalRegistry", sender));
    }

    private void printZenSymbol(String s, IZenSymbol zenSymbol) {
        if (zenSymbol instanceof SymbolPackage) {
            this.printZenSymbolHelper(zenSymbol, 0);
        } else {
            CraftTweakerAPI.logCommand((String)(s + ": " + zenSymbol.toString()));
        }
    }

    private void printZenSymbolHelper(IZenSymbol zenSymbol, int depth) {
        int finalDepth = depth + 1;
        if (zenSymbol instanceof SymbolPackage) {
            SymbolPackage symbolPackage = (SymbolPackage)zenSymbol;
            symbolPackage.getPackages().forEach((s1, symbol) -> {
                CraftTweakerAPI.logCommand((String)(StringUtils.repeat((String)"\t", (int)finalDepth) + s1 + ": " + symbol.toString()));
                this.printZenSymbolHelper((IZenSymbol)symbol, finalDepth);
            });
        } else if (zenSymbol instanceof SymbolType || zenSymbol instanceof ZenTypeNative) {
            ZenTypeNative typeNative = null;
            if (zenSymbol instanceof SymbolType) {
                ZenType type = ((SymbolType)zenSymbol).getType();
                if (type instanceof ZenTypeNative) {
                    typeNative = (ZenTypeNative)type;
                }
            } else {
                typeNative = (ZenTypeNative)zenSymbol;
            }
            if (typeNative != null) {
                for (String s : typeNative.dumpTypeInfo()) {
                    CraftTweakerAPI.logCommand((String)(StringUtils.repeat((String)"\t", (int)finalDepth) + s));
                }
            }
        }
    }
}

