/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.preprocessors;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Loader;

public class ModLoadedPreprocessor
extends PreprocessorActionBase {
    private static final String PREPROCESSOR_NAME = "modloaded";
    private List<LoadedMod> modNames = new ArrayList<LoadedMod>();

    public ModLoadedPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String[] names;
        String s = preprocessorLine.substring(10);
        for (String name : names = s.split(" ")) {
            String n = name.trim();
            if (n.length() <= 0) continue;
            boolean shouldBeLoaded = true;
            if (n.startsWith("!")) {
                n = n.substring(1);
                shouldBeLoaded = false;
            }
            this.modNames.add(new LoadedMod(n, shouldBeLoaded));
        }
    }

    public void executeActionOnFind(ScriptFile scriptFile) {
        if (!this.checkAreLoaded(this.modNames)) {
            CraftTweakerAPI.logInfo((String)("Ignoring script " + scriptFile + " due to the following #modloaded preprocessor settings: " + this.modNames));
            scriptFile.setParsingBlocked(true);
            scriptFile.setCompileBlocked(true);
            scriptFile.setExecutionBlocked(true);
        }
    }

    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }

    private boolean checkAreLoaded(List<LoadedMod> modNames) {
        for (LoadedMod mod : modNames) {
            if (Loader.isModLoaded((String)mod.modName) == mod.shouldBeLoaded) continue;
            return false;
        }
        return true;
    }

    private static class LoadedMod {
        String modName;
        boolean shouldBeLoaded;

        LoadedMod(String modName, boolean shouldBeLoaded) {
            this.modName = modName;
            this.shouldBeLoaded = shouldBeLoaded;
        }

        public String toString() {
            return "{" + (this.shouldBeLoaded ? "" : "!") + this.modName + "}";
        }
    }
}

