/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.potions;

import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.potions.MCPotion;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class MCPotionEffect
implements IPotionEffect {
    private final PotionEffect potionEffect;

    public MCPotionEffect(PotionEffect potionEffect) {
        this.potionEffect = potionEffect;
    }

    public int compareTo(IPotion other) {
        return this.potionEffect.compareTo((PotionEffect)other.getInternal());
    }

    public int getDuration() {
        return this.potionEffect.func_76459_b();
    }

    public IPotion getPotion() {
        return new MCPotion(this.potionEffect.func_188419_a());
    }

    public boolean doesShowParticles() {
        return this.potionEffect.func_188418_e();
    }

    public int getAmplifier() {
        return this.potionEffect.func_76458_c();
    }

    public List<IItemStack> getCurativeItems() {
        return this.potionEffect.getCurativeItems().stream().map(MCItemStack::new).collect(Collectors.toList());
    }

    public String getEffectName() {
        return this.potionEffect.func_76453_d();
    }

    public boolean isAmbient() {
        return this.potionEffect.func_82720_e();
    }

    public boolean isPotionDurationMax() {
        return this.potionEffect.func_100011_g();
    }

    public boolean isCurativeItem(IItemStack item) {
        return this.potionEffect.isCurativeItem((ItemStack)item.getInternal());
    }

    public void setIsPotionDurationMax(boolean potionDurationMax) {
        this.potionEffect.func_100012_b(potionDurationMax);
    }

    public void performEffect(IEntity entity) {
        if (entity.getInternal() instanceof EntityLivingBase) {
            this.potionEffect.func_76457_b((EntityLivingBase)entity.getInternal());
        }
    }

    public void combine(IPotionEffect other) {
        this.potionEffect.func_76452_a(CraftTweakerMC.getPotionEffect(other));
    }

    public Object getInternal() {
        return this.potionEffect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCPotionEffect that = (MCPotionEffect)o;
        return Objects.equals(this.potionEffect, that.potionEffect);
    }

    public int hashCode() {
        return Objects.hash(this.potionEffect);
    }
}

