/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.enchantments;

import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.enchantments.MCEnchantment;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MCEnchantmentDefinition
implements IEnchantmentDefinition {
    public final Enchantment enchantment;

    public MCEnchantmentDefinition(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public MCEnchantmentDefinition(int id) {
        this(Enchantment.func_185262_c((int)id));
    }

    public int getID() {
        return Enchantment.func_185258_b((Enchantment)this.enchantment);
    }

    public String getRegistryName() {
        ResourceLocation registryName = this.enchantment.getRegistryName();
        return registryName != null ? registryName.toString() : null;
    }

    public String getName() {
        return this.enchantment.func_77320_a();
    }

    public void setName(String name) {
        this.enchantment.func_77322_b(name);
    }

    public boolean canApply(IItemStack itemStack) {
        return this.enchantment.func_92089_a((ItemStack)itemStack.getInternal());
    }

    public boolean canApplyAtEnchantmentTable(IItemStack itemStack) {
        return this.enchantment.canApplyAtEnchantingTable((ItemStack)itemStack.getInternal());
    }

    public int getMaxLevel() {
        return this.enchantment.func_77325_b();
    }

    public int getMinLevel() {
        return this.enchantment.func_77319_d();
    }

    public int getMaxEnchantability(int enchantmentLevel) {
        return this.enchantment.func_77317_b(enchantmentLevel);
    }

    public int getMinEnchantability(int enchantmentLevel) {
        return this.enchantment.func_77321_a(enchantmentLevel);
    }

    public String getTranslatedName(int enchantmentLevel) {
        return this.enchantment.func_77316_c(enchantmentLevel);
    }

    public boolean isAllowedOnBooks() {
        return this.enchantment.isAllowedOnBooks();
    }

    public boolean isCompatibleWith(IEnchantmentDefinition other) {
        return this.enchantment.func_191560_c((Enchantment)other.getInternal());
    }

    public boolean isCurse() {
        return this.enchantment.func_190936_d();
    }

    public boolean isTreasureEnchantment() {
        return this.enchantment.func_185261_e();
    }

    public IEnchantment makeEnchantment(int level) {
        return new MCEnchantment(this.enchantment, level);
    }

    public int compare(IEnchantmentDefinition other) {
        return Integer.compare(this.getID(), other.getID());
    }

    public Object getInternal() {
        return this.enchantment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCEnchantmentDefinition that = (MCEnchantmentDefinition)o;
        return Objects.equals(this.enchantment, that.enchantment);
    }

    public int hashCode() {
        return Objects.hash(this.enchantment);
    }
}

