/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.ShapedRecipe;
import crafttweaker.api.recipes.ShapelessRecipe;
import crafttweaker.api.recipes.UnknownRecipe;
import crafttweaker.mc1120.recipes.ShapedRecipeAdvanced;
import crafttweaker.mc1120.recipes.ShapedRecipeBasic;
import crafttweaker.mc1120.recipes.ShapedRecipeOre;
import crafttweaker.mc1120.recipes.ShapelessRecipeAdvanced;
import crafttweaker.mc1120.recipes.ShapelessRecipeBasic;
import crafttweaker.mc1120.recipes.ShapelessRecipeOre;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Deprecated
public class RecipeConverter {
    public static final int TYPE_ADVANCED = 0;
    public static final int TYPE_ORE = 1;
    public static final int TYPE_BASIC = 2;

    private RecipeConverter() {
    }

    private static int getIngredientType(IIngredient pattern) {
        Object internal = pattern.getInternal();
        if (internal == null) {
            return 0;
        }
        if (internal instanceof ItemStack) {
            return 2;
        }
        return 1;
    }

    private static int getRecipeType(IIngredient[] ingredients) {
        int type = 2;
        for (IIngredient ingredient : ingredients) {
            type = Math.min(type, RecipeConverter.getIngredientType(ingredient));
        }
        return type;
    }

    public static IRecipe convert(ShapelessRecipe recipe, ResourceLocation name) {
        IIngredient[] ingredients = recipe.getIngredients();
        int type = RecipeConverter.getRecipeType(ingredients);
        if (type == 2) {
            NonNullList items = NonNullList.withSize((int)ingredients.length, (Object)Ingredient.EMPTY);
            for (int i = 0; i < ingredients.length; ++i) {
                items.set(i, (Object)Ingredient.fromStacks((ItemStack[])new ItemStack[]{CraftTweakerMC.getItemStack(ingredients[i])}));
            }
            return new ShapelessRecipeBasic(recipe.getName(), (NonNullList<Ingredient>)items, recipe);
        }
        if (type == 1) {
            Object[] items = new Object[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                items[i] = ingredients[i].getInternal();
            }
            return new ShapelessRecipeOre(name, items, recipe);
        }
        return new ShapelessRecipeAdvanced(recipe);
    }

    public static IRecipe convert(ShapedRecipe recipe, ResourceLocation name) {
        IIngredient[] ingredients = recipe.getIngredients();
        byte[] posx = recipe.getIngredientsX();
        byte[] posy = recipe.getIngredientsY();
        int type = RecipeConverter.getRecipeType(ingredients);
        if (type == 2) {
            NonNullList basicIngredients = NonNullList.withSize((int)(recipe.getHeight() * recipe.getWidth()), (Object)Ingredient.EMPTY);
            for (int i = 0; i < ingredients.length; ++i) {
                basicIngredients.set(posx[i] + posy[i] * recipe.getWidth(), (Object)Ingredient.fromStacks((ItemStack[])new ItemStack[]{CraftTweakerMC.getItemStack(ingredients[i])}));
            }
            return new ShapedRecipeBasic(recipe.getName(), (NonNullList<Ingredient>)basicIngredients, recipe);
        }
        if (type == 1) {
            Object[] converted = new Object[recipe.getHeight() * recipe.getWidth()];
            for (int i = 0; i < ingredients.length; ++i) {
                converted[posx[i] + posy[i] * recipe.getWidth()] = ingredients[i].getInternal();
            }
            int counter = 0;
            String[] parts = new String[recipe.getHeight()];
            ArrayList<Object> rarguments = new ArrayList<Object>();
            for (int i = 0; i < recipe.getHeight(); ++i) {
                char[] pattern = new char[recipe.getWidth()];
                for (int j = 0; j < recipe.getWidth(); ++j) {
                    int off = i * recipe.getWidth() + j;
                    if (converted[off] == null) {
                        pattern[j] = 32;
                        continue;
                    }
                    pattern[j] = (char)(65 + counter);
                    rarguments.add(Character.valueOf(pattern[j]));
                    rarguments.add(converted[off]);
                    ++counter;
                }
                parts[i] = new String(pattern);
            }
            rarguments.addAll(0, Arrays.asList(parts));
            return new ShapedRecipeOre(name, rarguments.toArray(), recipe);
        }
        return new ShapedRecipeAdvanced(recipe);
    }

    public static ICraftingRecipe toCraftingRecipe(IRecipe recipe) {
        IItemStack output = CraftTweakerMC.getIItemStack(recipe.getRecipeOutput());
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
            IIngredient[] ingredients = new IIngredient[shapeless.recipeItems.size()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = CraftTweakerMC.getIIngredient(shapeless.recipeItems.get(i));
            }
            return new ShapelessRecipe(recipe.getGroup(), output, ingredients, null, null);
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            IIngredient[][] ingredients = new IIngredient[shaped.recipeHeight][shaped.recipeWidth];
            for (int i = 0; i < shaped.recipeHeight; ++i) {
                for (int j = 0; j < shaped.recipeWidth; ++j) {
                    ItemStack stack = null;
                    for (ItemStack itemStack : ((Ingredient)shaped.recipeItems.get(i * shaped.recipeWidth + j)).getMatchingStacks()) {
                        if (stack != null || itemStack == null || itemStack.isEmpty()) continue;
                        stack = itemStack;
                    }
                    ingredients[i][j] = CraftTweakerMC.getIItemStack(stack);
                }
            }
            return new ShapedRecipe(recipe.getGroup(), output, ingredients, null, null, false);
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shaped = (ShapedOreRecipe)recipe;
            int width = ((ShapedOreRecipe)recipe).getRecipeWidth();
            int height = ((ShapedOreRecipe)recipe).getRecipeHeight();
            IIngredient[][] recipeIngredients = new IIngredient[height][width];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    recipeIngredients[i][j] = CraftTweakerMC.getIIngredient(shaped.getIngredients().get(i * width + j));
                }
            }
            return new ShapedRecipe(recipe.getRegistryName().getResourcePath(), output, recipeIngredients, null, null, false);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapeless = (ShapelessOreRecipe)recipe;
            IIngredient[] ingredients = new IIngredient[shapeless.getIngredients().size()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = CraftTweakerMC.getIIngredient(shapeless.getIngredients().get(i));
            }
            return new ShapelessRecipe(recipe.getRegistryName().getResourcePath(), output, ingredients, null, null);
        }
        return new UnknownRecipe(output);
    }
}

