/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.commands.Commands;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class NamesCommand
extends CraftTweakerCommand {
    private ArrayList<String> subCommands;

    public NamesCommand() {
        super("names");
    }

    @Override
    protected void init() {
        this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct names", "/ct names", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all item names in the game to the CraftTweaker log"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct names display unloc maxstack maxuse maxdamage rarity repaircost damageable repairable creativetabs enchantability burntime", "/ct names display unloc maxstack maxuse maxdamage rarity repaircost damageable repairable creativetabs", true), SpecialMessagesChat.getNormalMessage("  \u00a7bAdds all possible information to the output."));
        this.subCommands = new ArrayList(2);
        for (NameCommandParams para : NameCommandParams.values()) {
            if (para == NameCommandParams.REGISTRY_NAME) continue;
            this.subCommands.add(para.getCommandEquivalent());
        }
    }

    @Override
    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<NameCommandParams> paramList = new ArrayList<NameCommandParams>();
        paramList.add(NameCommandParams.REGISTRY_NAME);
        block0: for (String arg : args) {
            for (Object para : NameCommandParams.values()) {
                if (!para.getCommandEquivalent().equals(arg)) continue;
                paramList.add((NameCommandParams)((Object)para));
                continue block0;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>(BracketHandlerItem.getItemNames().values());
        items.sort(Commands.ITEM_COMPARATOR);
        CraftTweakerAPI.logCommand((String)"List of all registered Items:");
        StringBuilder syntaxStringBuilder = new StringBuilder();
        HashMap<NameCommandParams, Integer> timesUsed = new HashMap<NameCommandParams, Integer>();
        for (NameCommandParams param : paramList) {
            if (param == NameCommandParams.REGISTRY_NAME) {
                syntaxStringBuilder.append("\"").append(param.toString()).append("\"");
                continue;
            }
            syntaxStringBuilder.append(",\"").append(param.toString());
            if (!timesUsed.containsKey((Object)param)) {
                timesUsed.put(param, 1);
            } else {
                int t = (Integer)timesUsed.get((Object)param) + 1;
                timesUsed.replace(param, t);
                syntaxStringBuilder.append(t);
            }
            syntaxStringBuilder.append("\"");
        }
        CraftTweakerAPI.logCommand((String)syntaxStringBuilder.toString());
        int totalAmount = 0;
        for (Item item : items) {
            if (item == null) continue;
            NonNullList list = NonNullList.create();
            item.getSubItems(CreativeTabs.SEARCH, list);
            if (!list.isEmpty()) {
                for (ItemStack stack : list) {
                    CraftTweakerAPI.logCommand((String)this.createOutputForItem(stack, paramList));
                    ++totalAmount;
                }
                continue;
            }
            ItemStack stack = new ItemStack(item, 1, 0);
            CraftTweakerAPI.logCommand((String)this.createOutputForItem(stack, paramList));
        }
        CraftTweakerAPI.logCommand((String)("A total of " + items.size() + " unique Items registered by CraftTweaker."));
        CraftTweakerAPI.logCommand((String)("A total of " + totalAmount + " effective Items registered by CraftTweaker."));
        sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List generated", sender));
    }

    @Override
    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> currentPossibleCommands = new ArrayList<String>();
        if (args.length <= 0) {
            return new ArrayList<String>(this.subCommands);
        }
        for (String cmd : this.subCommands) {
            if (!cmd.startsWith(args[args.length - 1])) continue;
            currentPossibleCommands.add(cmd);
        }
        return currentPossibleCommands;
    }

    public static String prepareForCSV(String string) {
        return string.replace("\"", "\"\"");
    }

    protected String createOutputForItem(ItemStack stack, List<NameCommandParams> paramList) {
        StringBuilder sb = new StringBuilder();
        for (NameCommandParams type : paramList) {
            if (type == NameCommandParams.REGISTRY_NAME) {
                sb.append("\"");
            } else {
                sb.append(",\"");
            }
            sb.append(NamesCommand.prepareForCSV(type.getInformation(stack)));
            sb.append("\"");
        }
        return sb.toString();
    }

    private static enum NameCommandParams {
        REGISTRY_NAME("23498z9384z9283z49", stack -> {
            String nbt;
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(stack.getItem().getRegistryName() != null ? stack.getItem().getRegistryName().toString() : "[NO REGISTRY NAME] {" + stack.getItem().getClass().toString() + "}").append(stack.getMetadata() == 0 ? "" : ":" + stack.getMetadata()).append(">");
            if (stack.serializeNBT().hasKey("tag") && (nbt = NBTConverter.from(stack.serializeNBT().getTag("tag"), false).toString()).length() > 0) {
                sb.append(".withTag(").append(nbt).append(")");
            }
            return sb.toString();
        }),
        DISPLAY_NAME("display", ItemStack::getDisplayName),
        MOD_ID("modid", stack -> {
            ResourceLocation resLoc = stack.getItem().getRegistryName();
            return resLoc != null ? stack.getItem().getRegistryName().getResourceDomain() : "[NO REGISTRY NAME] {" + stack.getItem().getClass().toString() + "}";
        }),
        UNLOCALIZED("unloc", ItemStack::getUnlocalizedName),
        MAX_STACK_SIZE("maxstack", stack -> Integer.toString(stack.getMaxStackSize())),
        MAX_ITEM_USE_DURATION("maxuse", stack -> Integer.toString(stack.getMaxItemUseDuration())),
        MAX_ITEM_DAMAGE("maxdamage", stack -> Integer.toString(stack.getMaxDamage())),
        RARITY("rarity", stack -> stack.getItem().getForgeRarity(stack).getName()),
        REPAIR_COST("repaircost", stack -> Integer.toString(stack.getRepairCost())),
        DAMAGEABLE("damageable", stack -> Boolean.toString(stack.getItem().isDamageable())),
        REPAIRABLE("repairable", stack -> Boolean.toString(stack.getItem().isRepairable())),
        CREATIVE_TABS("creativetabs", stack -> {
            StringBuilder tabString = new StringBuilder();
            tabString.append("[");
            for (CreativeTabs creativeTabs : stack.getItem().getCreativeTabs()) {
                if (tabString.length() != 1) {
                    tabString.append(", ");
                }
                if (creativeTabs == null) continue;
                tabString.append(creativeTabs.getTabLabel());
            }
            tabString.append("]");
            return tabString.toString();
        }),
        ENCHANTABILITY("enchantability", stack -> Integer.toString(stack.getItem().getItemEnchantability(stack))),
        BURN_TIME("burntime", stack -> Integer.toString(TileEntityFurnace.getItemBurnTime((ItemStack)stack))),
        FOOD_VALUE("foodvalue", stack -> Integer.toString(stack.getItem() instanceof ItemFood ? ((ItemFood)stack.getItem()).getHealAmount(stack) : -1)),
        SATURATION_VALUE("saturationvalue", stack -> Float.toString(stack.getItem() instanceof ItemFood ? ((ItemFood)stack.getItem()).getSaturationModifier(stack) : -1.0f));

        private String commandEquivalent;
        private Function<ItemStack, String> informationProducer;

        private NameCommandParams(String commandEquivalent, Function<ItemStack, String> informationProducer) {
            this.commandEquivalent = commandEquivalent;
            this.informationProducer = informationProducer;
        }

        public String getCommandEquivalent() {
            return this.commandEquivalent;
        }

        public String getInformation(ItemStack stack) {
            return this.informationProducer.apply(stack);
        }
    }
}

