/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.ItemStackUnknown;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.api.recipes.ICraftingInfo;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.mc1120.recipes.MCCraftingInventorySquared;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import stanhebben.zenscript.util.ArrayUtil;
import stanhebben.zenscript.util.Pair;

public class MCRecipeShaped
extends MCRecipeBase
implements IShapedRecipe {
    private static final Pair<Integer, Integer> offsetInvalid = new Pair((Object)-1, (Object)-1);
    private final IIngredient[][] ingredients;
    private final int width;
    private final int height;
    private final boolean isMirrored;

    public MCRecipeShaped(IIngredient[][] ingredients, IItemStack output, IRecipeFunction recipeFunction, IRecipeAction recipeAction, boolean isMirrored, boolean isHidden) {
        super(output, MCRecipeShaped.createIngredientList(ingredients), recipeFunction, recipeAction, isHidden);
        this.height = ingredients.length;
        this.isMirrored = isMirrored;
        int width = 0;
        for (IIngredient[] ingredientLine : ingredients) {
            width = Math.max(width, ingredientLine.length);
        }
        this.ingredients = ingredients;
        for (int index = 0; index < this.ingredients.length; ++index) {
            if (this.ingredients[index].length >= width) continue;
            this.ingredients[index] = Arrays.copyOf(this.ingredients[index], width);
        }
        this.width = width;
    }

    private static NonNullList<Ingredient> createIngredientList(IIngredient[][] ingredients) {
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] ingredientLine : ingredients) {
            width = Math.max(width, ingredientLine.length);
        }
        NonNullList ingredientList = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
        for (int row = 0; row < ingredients.length; ++row) {
            for (int column = 0; column < ingredients[row].length; ++column) {
                if (ingredients[row][column] == null) continue;
                ingredientList.set(row * width + column, (Object)CraftTweakerMC.getIngredient(ingredients[row][column]));
            }
        }
        return ingredientList;
    }

    public boolean matches(InventoryCrafting inv, World worldIn) {
        return this.calculateOffset(inv) != offsetInvalid;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        Pair<Integer, Integer> offsetPair = this.checkRecipe(this.ingredients, inv);
        if (offsetPair != offsetInvalid || !this.isMirrored) {
            return this.getCraftingResult(inv, offsetPair, this.ingredients);
        }
        IIngredient[][] ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])this.ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inv);
        if (offsetPair != offsetInvalid) {
            return this.getCraftingResult(inv, offsetPair, ingredients);
        }
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = (IIngredient[])ArrayUtil.inverse((Object[])this.ingredients[i], (int)this.width);
        }
        offsetPair = this.checkRecipe(ingredients, inv);
        if (offsetPair != offsetInvalid) {
            return this.getCraftingResult(inv, offsetPair, ingredients);
        }
        ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inv);
        return this.getCraftingResult(inv, offsetPair, ingredients);
    }

    private ItemStack getCraftingResult(InventoryCrafting inv, Pair<Integer, Integer> offsetPair, IIngredient[][] ingredients) {
        if (offsetPair == offsetInvalid) {
            return ItemStack.EMPTY;
        }
        int rowOffset = (Integer)offsetPair.getKey();
        int columnOffset = (Integer)offsetPair.getValue();
        if (this.recipeFunction != null) {
            HashMap<String, IItemStack> marks = new HashMap<String, IItemStack>();
            for (int row = 0; row < ingredients.length; ++row) {
                for (int column = 0; column < ingredients[row].length; ++column) {
                    IIngredient ingredient = ingredients[row][column];
                    if (ingredient == null || ingredient.getMark() == null) continue;
                    marks.put(ingredient.getMark(), CraftTweakerMC.getIItemStack(inv.getStackInRowAndColumn(column + columnOffset, row + rowOffset)));
                }
            }
            IItemStack out = null;
            try {
                out = this.recipeFunction.process(this.output, marks, (ICraftingInfo)new CraftingInfo((ICraftingInventory)MCCraftingInventorySquared.get((IInventory)inv), null));
            }
            catch (Exception exception) {
                CraftTweakerAPI.logError((String)"Could not execute RecipeFunction: ", (Throwable)exception);
            }
            return CraftTweakerMC.getItemStack(out);
        }
        return CraftTweakerMC.getItemStack(this.output);
    }

    public boolean canFit(int width, int height) {
        return this.width <= width && this.height <= height;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return CraftTweakerMC.getItemStack(this.output);
    }

    @Override
    public void applyTransformers(InventoryCrafting inventory, IPlayer byPlayer) {
        Pair<Integer, Integer> offsetPair = this.checkRecipe(this.ingredients, inventory);
        if (offsetPair != offsetInvalid || !this.isMirrored) {
            this.applyTransformers(inventory, byPlayer, offsetPair, this.ingredients);
            return;
        }
        IIngredient[][] ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])this.ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inventory);
        if (offsetPair != offsetInvalid) {
            this.applyTransformers(inventory, byPlayer, offsetPair, ingredients);
            return;
        }
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = (IIngredient[])ArrayUtil.inverse((Object[])this.ingredients[i], (int)this.width);
        }
        offsetPair = this.checkRecipe(ingredients, inventory);
        if (offsetPair != offsetInvalid) {
            this.applyTransformers(inventory, byPlayer, offsetPair, ingredients);
            return;
        }
        ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inventory);
        this.applyTransformers(inventory, byPlayer, offsetPair, ingredients);
    }

    private void applyTransformers(InventoryCrafting inventory, IPlayer byPlayer, Pair<Integer, Integer> offsetPair, IIngredient[][] ingredients) {
        if (offsetPair == offsetInvalid) {
            return;
        }
        int rowOffset = (Integer)offsetPair.getKey();
        int columnOffset = (Integer)offsetPair.getValue();
        for (int column = 0; column < this.height; ++column) {
            for (int row = 0; row < this.width; ++row) {
                IIngredient ingredient;
                ItemStack itemStack = inventory.getStackInSlot(column + columnOffset + (row + rowOffset) * inventory.getWidth());
                if (ingredients.length <= row || ingredients[row].length <= column || (ingredient = ingredients[row][column]) == null || !ingredient.hasTransformers()) continue;
                IItemStack out = null;
                try {
                    out = ingredient.applyTransform(CraftTweakerMC.getIItemStack(itemStack), byPlayer);
                }
                catch (Exception exception) {
                    CraftTweakerAPI.logError((String)("Could not execute RecipeTransformer on : " + ingredient.toCommandString()), (Throwable)exception);
                }
                inventory.setInventorySlotContents(column + columnOffset + (row + rowOffset) * inventory.getWidth(), CraftTweakerMC.getItemStack(out));
            }
        }
    }

    @Override
    public MCRecipeShaped update() {
        this.ingredientList = MCRecipeShaped.createIngredientList(this.ingredients);
        return this;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        Pair<Integer, Integer> offsetPair = this.checkRecipe(this.ingredients, inv);
        if (offsetPair != offsetInvalid || !this.isMirrored) {
            return this.getRemainingItems(inv, offsetPair, this.ingredients);
        }
        IIngredient[][] ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])this.ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inv);
        if (offsetPair != offsetInvalid) {
            return this.getRemainingItems(inv, offsetPair, ingredients);
        }
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = (IIngredient[])ArrayUtil.inverse((Object[])this.ingredients[i], (int)this.width);
        }
        offsetPair = this.checkRecipe(ingredients, inv);
        if (offsetPair != offsetInvalid) {
            return this.getRemainingItems(inv, offsetPair, ingredients);
        }
        ingredients = (IIngredient[][])ArrayUtil.inverse((Object[])ingredients, (int)this.height);
        offsetPair = this.checkRecipe(ingredients, inv);
        return this.getRemainingItems(inv, offsetPair, ingredients);
    }

    private NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv, Pair<Integer, Integer> offsetPair, IIngredient[][] ingredients) {
        NonNullList out = NonNullList.withSize((int)inv.getSizeInventory(), (Object)ItemStack.EMPTY);
        if (offsetPair == offsetInvalid) {
            return out;
        }
        int rowOffset = (Integer)offsetPair.getKey();
        int columnOffset = (Integer)offsetPair.getValue();
        for (int column = 0; column < this.width; ++column) {
            for (int row = 0; row < this.height; ++row) {
                ItemStack itemStack = inv.getStackInSlot(column + columnOffset + (row + rowOffset) * inv.getWidth());
                if (ingredients.length <= row || ingredients[row].length <= column) continue;
                IIngredient ingredient = ingredients[row][column];
                boolean needsContainerItem = true;
                if (ingredient == null) continue;
                if (ingredient.hasNewTransformers()) {
                    IItemStack remainingItem = null;
                    try {
                        remainingItem = ingredient.applyNewTransform(CraftTweakerMC.getIItemStack(itemStack));
                    }
                    catch (Exception exception) {
                        CraftTweakerAPI.logError((String)("Could not execute NewRecipeTransformer on " + ingredient.toCommandString() + ":"), (Throwable)exception);
                    }
                    if (remainingItem != ItemStackUnknown.INSTANCE) {
                        out.set(column + columnOffset + (row + rowOffset) * inv.getWidth(), (Object)CraftTweakerMC.getItemStack(remainingItem));
                        needsContainerItem = false;
                    }
                }
                if (ingredient.hasTransformers()) {
                    itemStack.setCount(itemStack.getCount() + 1);
                    needsContainerItem = false;
                }
                if (!needsContainerItem) continue;
                out.set(column + columnOffset + (row + rowOffset) * inv.getWidth(), (Object)ForgeHooks.getContainerItem((ItemStack)itemStack));
            }
        }
        return out;
    }

    public IIngredient[][] getIIngredients() {
        return this.ingredients;
    }

    private Pair<Integer, Integer> calculateOffset(InventoryCrafting inv) {
        Pair<Integer, Integer> offset = this.checkRecipe(this.ingredients, inv);
        if (offset != offsetInvalid || !this.isMirrored) {
            return offset;
        }
        offset = this.checkRecipe((IIngredient[][])ArrayUtil.inverse((Object[])this.ingredients, (int)this.height), inv);
        if (offset != offsetInvalid) {
            return offset;
        }
        IIngredient[][] ingredients = new IIngredient[this.ingredients.length][];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = (IIngredient[])ArrayUtil.inverse((Object[])this.ingredients[i], (int)this.width);
        }
        offset = this.checkRecipe(ingredients, inv);
        if (offset != offsetInvalid) {
            return offset;
        }
        return this.checkRecipe((IIngredient[][])ArrayUtil.inverse((Object[])ingredients, (int)this.height), inv);
    }

    private Pair<Integer, Integer> checkRecipe(IIngredient[][] ingredients, InventoryCrafting inv) {
        boolean[] visited = new boolean[inv.getSizeInventory()];
        for (int rowOffset = 0; rowOffset <= inv.getHeight() - this.height; ++rowOffset) {
            block1: for (int columnOffset = 0; columnOffset <= inv.getWidth() - this.width; ++columnOffset) {
                int slot;
                for (int row = 0; row < ingredients.length; ++row) {
                    for (int column = 0; column < ingredients[row].length; ++column) {
                        ItemStack itemStack = inv.getStackInRowAndColumn(column + columnOffset, row + rowOffset);
                        if (ingredients[row][column] == null) {
                            if (itemStack.isEmpty()) continue;
                            return offsetInvalid;
                        }
                        if (itemStack.isEmpty() || !ingredients[row][column].matches(CraftTweakerMC.getIItemStackForMatching(itemStack))) continue block1;
                        visited[column + columnOffset + (row + rowOffset) * inv.getWidth()] = true;
                    }
                }
                for (slot = 0; slot < visited.length; ++slot) {
                    if (visited[slot] || inv.getStackInSlot(slot).isEmpty()) continue;
                    return offsetInvalid;
                }
                for (slot = 0; slot < inv.getSizeInventory(); ++slot) {
                    int row = slot / inv.getWidth() - rowOffset;
                    int column = slot % inv.getWidth() - columnOffset;
                    if (row >= 0 && column >= 0 || inv.getStackInSlot(slot).isEmpty()) continue;
                    return offsetInvalid;
                }
                return new Pair((Object)rowOffset, (Object)columnOffset);
            }
        }
        return offsetInvalid;
    }

    public String toCommandString() {
        StringBuilder commandString = new StringBuilder("recipes.add");
        commandString.append(this.hidden ? "Hidden" : "");
        commandString.append("Shaped(\"");
        commandString.append(this.getName()).append("\", ");
        commandString.append(this.output.toString()).append(", [");
        if (this.height > 0 && this.width > 0) {
            for (int row = 0; row < this.height; ++row) {
                commandString.append("[");
                for (int column = 0; column < this.width; ++column) {
                    IIngredient ingredient = this.ingredients[row][column];
                    commandString.append(ingredient == null ? "null" : ingredient.toCommandString()).append(", ");
                }
                commandString.deleteCharAt(commandString.length() - 1);
                commandString.deleteCharAt(commandString.length() - 1);
                commandString.append("], ");
            }
            commandString.deleteCharAt(commandString.length() - 1);
            commandString.deleteCharAt(commandString.length() - 1);
        }
        return commandString.append("]);").toString();
    }

    public boolean hasTransformers() {
        IIngredient[][] iIngredientArray = this.ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] row;
            for (IIngredient ingredient : row = iIngredientArray[i]) {
                if (ingredient == null || !ingredient.hasTransformers()) continue;
                return true;
            }
        }
        return false;
    }

    public IIngredient[] getIngredients1D() {
        IIngredient[] out = new IIngredient[this.ingredientList.size()];
        int index = 0;
        IIngredient[][] iIngredientArray = this.ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] row;
            for (IIngredient ingredient : row = iIngredientArray[i]) {
                out[index++] = ingredient;
            }
        }
        return out;
    }

    public IIngredient[][] getIngredients2D() {
        return this.ingredients;
    }

    public boolean isShaped() {
        return true;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }
}

