/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.event.EntityLivingSpawnEvent;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.tileentity.IMobSpawnerBaseLogic;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.tileentity.MCMobSpawnerBaseLogic;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MCEntityLivingSpawnEvent
implements EntityLivingSpawnEvent {
    protected final LivingSpawnEvent event;

    public MCEntityLivingSpawnEvent(LivingSpawnEvent event) {
        this.event = event;
    }

    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld(this.event.getWorld());
    }

    public float getX() {
        return this.event.getX();
    }

    public float getY() {
        return this.event.getY();
    }

    public float getZ() {
        return this.event.getZ();
    }

    public void allow() {
        this.event.setResult(Event.Result.ALLOW);
    }

    public void deny() {
        this.event.setResult(Event.Result.DENY);
    }

    public void pass() {
        this.event.setResult(Event.Result.DEFAULT);
    }

    public IEntityLivingBase getEntityLivingBase() {
        return CraftTweakerMC.getIEntityLivingBase(this.event.getEntityLiving());
    }

    public static class MCEntityLivingSpecialSpawnEvent
    extends MCEntityLivingExtendedSpawnEvent {
        public MCEntityLivingSpecialSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
            super(event);
        }

        @Override
        public void allow() {
            this.event.setCanceled(false);
        }

        @Override
        public void deny() {
            this.event.setCanceled(true);
        }

        @Override
        public void pass() {
        }
    }

    public static class MCEntityLivingExtendedSpawnEvent
    extends MCEntityLivingSpawnEvent
    implements EntityLivingSpawnEvent.EntityLivingExtendedSpawnEvent {
        private final IMobSpawnerBaseLogic spawnerBaseLogic;

        public MCEntityLivingExtendedSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
            super((LivingSpawnEvent)event);
            this.spawnerBaseLogic = event.getSpawner() == null ? null : new MCMobSpawnerBaseLogic(event.getSpawner());
        }

        public MCEntityLivingExtendedSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
            super((LivingSpawnEvent)event);
            this.spawnerBaseLogic = event.getSpawner() == null ? null : new MCMobSpawnerBaseLogic(event.getSpawner());
        }

        public IMobSpawnerBaseLogic getSpawner() {
            return this.spawnerBaseLogic;
        }
    }
}

