/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import com.google.gson.JsonPrimitive;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.mods.IMod;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IFurnaceRecipe;
import crafttweaker.api.world.IBiome;
import crafttweaker.mc1120.brackets.BracketHandlerBiomeType;
import crafttweaker.mc1120.brackets.BracketHandlerEnchantments;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.ClipboardHelper;
import crafttweaker.mc1120.commands.CommandUtils;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.DumpZsCommand;
import crafttweaker.mc1120.commands.GiveCommand;
import crafttweaker.mc1120.commands.HelpCommand;
import crafttweaker.mc1120.commands.NBTUtils;
import crafttweaker.mc1120.commands.NamesCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.commands.dumpzscommand.TargetHtml;
import crafttweaker.mc1120.commands.dumpzscommand.TargetJson;
import crafttweaker.mc1120.commands.dumpzscommand.TargetLog;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.player.MCPlayer;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.runtime.ScriptLoader;
import crafttweaker.socket.CrTSocketHandler;
import crafttweaker.util.IEventHandler;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.input.Keyboard;

public class Commands {
    public static final PotionComparator POTION_COMPARATOR = new PotionComparator();
    public static final Comparator<Item> ITEM_COMPARATOR = new ItemComparator();

    static void registerCommands() {
        CTChatCommand.registerCommand(new CraftTweakerCommand("foods"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Foods:");
                for (IItemDefinition item : CraftTweakerAPI.game.getItems()) {
                    for (IItemStack stack : item.getSubItems()) {
                        if (!stack.isFood()) continue;
                        CraftTweakerAPI.logCommand((String)("- " + stack.toCommandString() + " Heal amount: " + stack.getHealAmount() + " Saturation amount: " + stack.getSaturation()));
                    }
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of foods generated;", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct foods", "/ct foods", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all foods in the game to the crafttweaker.log"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("liquids"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List liquids = CraftTweakerAPI.game.getLiquids();
                liquids.sort(CrafttweakerImplementationAPI.LIQUID_COMPARATOR);
                CraftTweakerAPI.logCommand((String)"Liquids:");
                for (ILiquidDefinition liquid : liquids) {
                    StringBuilder builder = new StringBuilder("<liquid:" + liquid.getName() + ">").append("\n");
                    builder.append("- Name: ").append(liquid.getName()).append("\n");
                    builder.append("- Display Name: ").append(liquid.getDisplayName()).append("\n");
                    builder.append("- Luminosity:").append(liquid.getLuminosity()).append("\n");
                    builder.append("- Density: ").append(liquid.getDensity()).append("\n");
                    builder.append("- Temperature: ").append(liquid.getTemperature()).append("\n");
                    builder.append("- Viscosity: ").append(liquid.getViscosity()).append("\n");
                    builder.append("- Gaseous: ").append(liquid.isGaseous());
                    CraftTweakerAPI.logCommand((String)builder.toString());
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of liquids generated;", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct liquids", "/ct liquids", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all liquid names in the game to the crafttweaker.log"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("blocks"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List blocks = CraftTweakerAPI.game.getBlocks();
                blocks.sort(CrafttweakerImplementationAPI.BLOCK_COMPARATOR);
                CraftTweakerAPI.logCommand((String)"Blocks:");
                for (IBlockDefinition block : blocks) {
                    CraftTweakerAPI.logCommand((String)("<block:" + block.getId() + ">, " + block.getDisplayName()));
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of blocks generated", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct blocks", "/ct blocks", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all blocks in the game to the crafttweaker log"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("entities"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct entities", "/ct entities", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all entity definitions in the game to the crafttweaker log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List entities = CraftTweakerAPI.game.getEntities();
                entities.sort(CrafttweakerImplementationAPI.ENTITY_COMPARATOR);
                CraftTweakerAPI.logCommand((String)"Entities:");
                for (IEntityDefinition entity : entities) {
                    CraftTweakerAPI.logCommand((String)(entity.getId() + " -- " + entity.getName()));
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Entities generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("potions"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct potions", "/ct potions", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all potions to the crafttweaker.log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List potions = CraftTweakerAPI.game.getPotions();
                potions.sort(POTION_COMPARATOR);
                CraftTweakerAPI.logCommand((String)"Potions:");
                BracketHandlerPotion.getPotionNames().forEach((k, v) -> {
                    int id = Potion.REGISTRY.getIDForObject(v);
                    CraftTweakerAPI.logCommand((String)(k + " -- color: " + v.getLiquidColor() + (v.isBadEffect() ? " -- is bad effect" : " -- is good effect") + " -- PotionID: " + id));
                });
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Potions generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("recipeNames"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct recipeNames", "/ct recipeNames", true), SpecialMessagesChat.getNormalMessage(" \u00a73A modid can be provided to filter results"), SpecialMessagesChat.getNormalMessage(" \u00a73/ct recipeNames <modid>"), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all crafting recipe names in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Recipe names:");
                String filter = args.length == 0 ? "" : args[0];
                for (Map.Entry entry : ForgeRegistries.RECIPES.getEntries()) {
                    if (!filter.isEmpty() && !((ResourceLocation)entry.getKey()).getResourceDomain().equalsIgnoreCase(filter)) continue;
                    CraftTweakerAPI.logCommand((String)(((ResourceLocation)entry.getKey()).toString() + " - " + ((IRecipe)entry.getValue()).getRecipeOutput()));
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("reload"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct reload", "/ct reload", true), SpecialMessagesChat.getNormalMessage(" \u00a73Gives information as to why reloading is not possible"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.sendMessage(SpecialMessagesChat.getNormalMessage("Unfortunately reloading is not possible due to a forge change."));
                sender.sendMessage(SpecialMessagesChat.getClickableBrowserLinkText("Please read this", "https://www.reddit.com/r/feedthebeast/comments/6oxjtd/lets_talk_crafttweaker_reload/"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("recipes"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct recipes", "/ct recipes", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all crafting recipes in the game"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct recipes hand", "/ct recipes hand", true), SpecialMessagesChat.getNormalMessage("  \u00a7bLists all crafting recipes for the item in your hand"), SpecialMessagesChat.getNormalMessage("  \u00a7bAlso copies the recipes to clipboard"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct recipes furnace", "/ct recipes furnace", true), SpecialMessagesChat.getNormalMessage("  \u00a7blists all furnace recipes in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length == 0) {
                    sender.sendMessage((ITextComponent)new TextComponentString("Generating recipe list, this could take a while..."));
                    CraftTweakerAPI.logCommand((String)"Recipes:");
                    for (ICraftingRecipe recipe : CraftTweakerAPI.recipes.getAll()) {
                        try {
                            CraftTweakerAPI.logCommand((String)recipe.toCommandString());
                        }
                        catch (Exception ex) {
                            if (recipe instanceof MCRecipeBase) {
                                MCRecipeBase recipeBase = (MCRecipeBase)recipe;
                                IItemStack out = recipeBase.getOutput();
                                CraftTweakerAPI.logError((String)("Could not dump recipe for " + out), (Throwable)ex);
                                continue;
                            }
                            CraftTweakerAPI.logError((String)"Could not dump recipe", (Throwable)ex);
                        }
                    }
                    sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
                } else if (args[0].equals("hand") && sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    IItemStack item = player.getCurrentItem();
                    if (item != null) {
                        List recipes = CraftTweakerAPI.recipes.getRecipesFor((IIngredient)item.anyAmount());
                        if (recipes.isEmpty()) {
                            player.sendChat("No crafting recipes found for that item");
                        } else {
                            StringBuilder recipesString = new StringBuilder();
                            for (ICraftingRecipe recipe : recipes) {
                                CraftTweakerAPI.logCommand((String)recipe.toCommandString());
                                player.sendChat(recipe.toCommandString());
                                recipesString.append(recipe.toCommandString()).append("\n");
                            }
                            player.copyToClipboard(recipesString.toString());
                        }
                    } else {
                        player.sendChat("No item was found");
                    }
                } else if (args[0].equals("furnace")) {
                    sender.sendMessage((ITextComponent)new TextComponentString("Generating furnace list, this could take a while..."));
                    CraftTweakerAPI.logCommand((String)"Furnace Recipes:");
                    for (IFurnaceRecipe recipe : CraftTweakerAPI.furnace.getAll()) {
                        try {
                            CraftTweakerAPI.logCommand((String)recipe.toCommandString());
                        }
                        catch (Exception ex) {
                            CraftTweakerAPI.logError((String)"Could not dump furnace recipe", (Throwable)ex);
                        }
                    }
                    sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Furnace Recipe list generated", sender));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("Invalid arguments for recipes command"));
                }
            }

            @Override
            public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                String[] subCommands = new String[]{"hand", "furnace"};
                ArrayList<String> currentPossibleCommands = new ArrayList<String>();
                for (String cmd : subCommands) {
                    if (!cmd.startsWith(args[0])) continue;
                    currentPossibleCommands.add(cmd);
                }
                return currentPossibleCommands;
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("inventory"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct inventory", "/ct inventory", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all items in your inventory"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                Entity entity = sender.getCommandSenderEntity();
                if (entity instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)entity);
                    for (int i = 0; i < player.getInventorySize(); ++i) {
                        IItemStack stack = player.getInventoryStack(i);
                        if (stack == null) continue;
                        CraftTweakerAPI.logCommand((String)stack.toString());
                    }
                    sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("This command can only be used as a Player (inGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("hand"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct hand", "/ct hand", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs the name of the item in your hand"), SpecialMessagesChat.getNormalMessage(" \u00a73Also copies the name to clipboard and prints"), SpecialMessagesChat.getNormalMessage(" \u00a73OreDict entries"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                block15: {
                    if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)sender.getCommandSenderEntity();
                        ItemStack heldItem = player.getHeldItemMainhand();
                        if (!heldItem.isEmpty()) {
                            String nbt;
                            List<String> oreDictNames = CommandUtils.getOreDictOfItem(heldItem);
                            int meta = heldItem.getMetadata();
                            String itemName = "<" + heldItem.getItem().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                            String withNBT = "";
                            if (heldItem.serializeNBT().hasKey("tag") && (nbt = NBTConverter.from(heldItem.serializeNBT().getTag("tag"), false).toString()).length() > 0) {
                                withNBT = ".withTag(" + nbt + ")";
                            }
                            ClipboardHelper.copyStringPlayer(player, itemName + withNBT);
                            ClipboardHelper.sendMessageWithCopy(player, "Item \u00a72" + itemName + "\u00a7a" + withNBT, itemName + withNBT);
                            ILiquidStack liquidStack = CraftTweakerMC.getILiquidStack(FluidUtil.getFluidContained((ItemStack)heldItem));
                            if (liquidStack != null) {
                                String liquidCommandString = liquidStack.toCommandString();
                                ClipboardHelper.sendMessageWithCopy(player, "Contains Liquid \u00a72" + (String)liquidCommandString, liquidCommandString);
                            }
                            if (!oreDictNames.isEmpty()) {
                                sender.sendMessage((ITextComponent)new TextComponentString("\u00a73OreDict Entries:"));
                                for (String oreName : oreDictNames) {
                                    ClipboardHelper.sendMessageWithCopy(player, "    \u00a7e- \u00a7b" + oreName, "<ore:" + oreName + ">");
                                }
                            } else {
                                sender.sendMessage((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                            }
                        } else {
                            RayTraceResult rayTraceResult = CommandUtils.getPlayerLookat(player, 100.0);
                            if (rayTraceResult != null && rayTraceResult.typeOfHit == RayTraceResult.Type.BLOCK) {
                                BlockPos blockPos = rayTraceResult.getBlockPos();
                                IBlockState block = server.getEntityWorld().getBlockState(blockPos);
                                int meta = block.getBlock().getMetaFromState(block);
                                String blockName = "<" + block.getBlock().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                                ClipboardHelper.copyStringPlayer(player, blockName);
                                ClipboardHelper.sendMessageWithCopy(player, "Block \u00a72" + blockName + " \u00a7rat \u00a79[" + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ() + "]\u00a7r", blockName);
                                try {
                                    List<String> oreDictNames = CommandUtils.getOreDictOfItem(new ItemStack(block.getBlock(), 1, block.getBlock().getMetaFromState(block)));
                                    if (!oreDictNames.isEmpty()) {
                                        sender.sendMessage((ITextComponent)new TextComponentString("\u00a73OreDict Entries:"));
                                        for (String oreName : oreDictNames) {
                                            ClipboardHelper.sendMessageWithCopy(player, "    \u00a7e- \u00a7b" + oreName, "<ore:" + oreName + ">");
                                        }
                                        break block15;
                                    }
                                    sender.sendMessage((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                                }
                                catch (IllegalArgumentException e) {
                                    sender.sendMessage((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                                }
                            } else {
                                sender.sendMessage((ITextComponent)new TextComponentString("\u00a74Please hold an Item in your hand or look at a Block."));
                            }
                        }
                    } else {
                        sender.sendMessage((ITextComponent)new TextComponentString("This command can only be casted by a player inGame"));
                    }
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("json"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct json", "/ct json", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs the nbt of the item in your hand"), SpecialMessagesChat.getNormalMessage(" \u00a73This format is in json format, different from the one used in ZenScript"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct json escaped", "/ct json escaped", true), SpecialMessagesChat.getNormalMessage("  \u00a7bAutomatically escapes the string to use in json."));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender.getCommandSenderEntity();
                    ItemStack heldItem = player.getHeldItemMainhand();
                    if (!heldItem.isEmpty()) {
                        int meta = heldItem.getMetadata();
                        String itemName = "[" + heldItem.getItem().getRegistryName() + (meta == 0 ? "" : ":" + meta) + "]";
                        String withNBT = "";
                        if (heldItem.serializeNBT().hasKey("tag")) {
                            String nbt = heldItem.serializeNBT().getTag("tag").toString();
                            if (args.length == 1) {
                                nbt = new JsonPrimitive(nbt).toString();
                            }
                            if (nbt.length() > 0) {
                                withNBT = " NBT: [" + nbt + "]";
                            }
                        }
                        ClipboardHelper.copyStringPlayer(player, itemName + withNBT);
                        ClipboardHelper.sendMessageWithCopy(player, "Item \u00a72" + itemName + "\u00a7a" + withNBT, itemName + withNBT);
                    } else {
                        sender.sendMessage((ITextComponent)new TextComponentString("\u00a74Please hold an Item in your hand."));
                    }
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("This command can only be casted by a player inGame"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("mods"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct mods", "/ct mods", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs all active mod IDs and versions in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Mods list:");
                for (IMod mod : CraftTweakerAPI.loadedMods) {
                    String message = "\u00a75" + mod.getId() + "\u00a7r - \u00a7d" + mod.getName() + "\u00a7 - " + mod.getVersion();
                    String messageWithoutColor = mod.getId() + " - " + mod.getName() + " - " + mod.getVersion();
                    sender.sendMessage((ITextComponent)new TextComponentString(message));
                    CraftTweakerAPI.logCommand((String)messageWithoutColor);
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Mods generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("oredict"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct oredict", "/ct oredict", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs all ore dictionary entries in the game to the crafttweaker log"), SpecialMessagesChat.getClickableCommandText("\u00a7a/ct oredict <name>", "/ct oredict ", false), SpecialMessagesChat.getNormalMessage("  \u00a7bOutputs all items in the given ore dictionary entry to the crafttweaker log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length > 0) {
                    String entryName = args[0];
                    IOreDictEntry entry = CraftTweakerAPI.oreDict.get(entryName);
                    if (entry.isEmpty()) {
                        sender.sendMessage((ITextComponent)new TextComponentString("Entry doesn't exist"));
                        return;
                    }
                    CraftTweakerAPI.logCommand((String)("Ore entries for " + entryName + ":"));
                    for (IItemStack ore : entry.getItems()) {
                        CraftTweakerAPI.logCommand((String)("-" + ore));
                    }
                } else {
                    for (IOreDictEntry entry : CraftTweakerAPI.oreDict.getEntries()) {
                        if (entry.isEmpty()) continue;
                        CraftTweakerAPI.logCommand((String)("Ore entries for <ore:" + entry.getName() + "> :"));
                        for (IItemStack ore : entry.getItems()) {
                            CraftTweakerAPI.logCommand((String)("-" + ore));
                        }
                    }
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("OreDict list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("seeds"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct seeds", "/ct seeds", true), SpecialMessagesChat.getNormalMessage(" \u00a73Prints all seeds registered"), SpecialMessagesChat.getNormalMessage(" \u00a73for tall grass"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Seeds:");
                for (WeightedItemStack seed : CraftTweakerAPI.vanilla.getSeeds().getSeeds()) {
                    String itemname = "<" + seed.getStack().getName() + ":" + seed.getStack().getDamage() + ">";
                    String message = "\u00a72" + itemname + "\u00a7r - \u00a7e" + (int)seed.getChance();
                    sender.sendMessage(SpecialMessagesChat.getCopyMessage(message, itemname));
                    CraftTweakerAPI.logCommand((String)("Seed: " + message));
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Seed list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("wiki"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct wiki", "/ct wiki", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the wiki"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                String url = "https://docs.blamejared.com/1.12";
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    player.openBrowser(url);
                    sender.sendMessage(SpecialMessagesChat.getClickableBrowserLinkText(url, url));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString(url));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("bugs"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct bugs", "/ct bugs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the GitHub bug tracker"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    player.openBrowser("https://github.com/CraftTweaker/CraftTweaker/issues");
                    sender.sendMessage(SpecialMessagesChat.getClickableBrowserLinkText("https://github.com/CraftTweaker/CraftTweaker/issues", "https://github.com/CraftTweaker/CraftTweaker/issues"));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("https://github.com/CraftTweaker/CraftTweaker/issues"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("discord"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct discord", "/ct discord", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with a link to the Discord server"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    player.openBrowser("https://discord.blamejared.com/");
                    sender.sendMessage(SpecialMessagesChat.getClickableBrowserLinkText("https://discord.blamejared.com/", "https://discord.blamejared.com/"));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("https://discord.blamejared.com/"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("docs"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct docs", "/ct docs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the docs"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    player.openBrowser("http://docs.blamejared.com/en/");
                    sender.sendMessage(SpecialMessagesChat.getClickableBrowserLinkText("http://docs.blamejared.com/en/", "http://docs.blamejared.com/en/"));
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("http://docs.blamejared.com/en/"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("biomes"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct biomes", "/ct biomes", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all the biomes in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Biomes:");
                for (IBiome biome : CraftTweakerAPI.game.getBiomes()) {
                    CraftTweakerAPI.logCommand((String)("-" + biome.getId() + "\t" + biome.getName()));
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Biome list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("biomeTypes"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct biomeTypes", "/ct biomeTypes", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all the biome types in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Biome Types:");
                BracketHandlerBiomeType.biomeTypes.forEach((s, iBiomeType) -> CraftTweakerAPI.logCommand((String)("-" + s)));
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Biome Types list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("enchants"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct enchants", "/ct enchants", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all the enchants in the game."));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"Enchants:");
                BracketHandlerEnchantments.enchantments.forEach((s, iEnchant) -> {
                    String name = ((Enchantment)iEnchant.getInternal()).getTranslatedName(1);
                    CraftTweakerAPI.logCommand((String)String.format("-<enchantment:%s> - %s (at level 1, max level %d, treasure: %s, enchant id %d)", s, name, iEnchant.getMaxLevel(), iEnchant.isTreasureEnchantment() ? "yes" : "no", iEnchant.getID()));
                });
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("Enchants list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("blockinfo"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct blockinfo", "/ct blockinfo", true), SpecialMessagesChat.getNormalMessage(" \u00a73Activates or deactivates block reader. In block info mode,"), SpecialMessagesChat.getNormalMessage(" \u00a73right-click a block to see ID, meta and tile entity data"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.getCommandSenderEntity());
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.isEmpty()) {
                        CrafttweakerImplementationAPI.blockEventHandler = CrafttweakerImplementationAPI.events.onPlayerInteract((IEventHandler)CrafttweakerImplementationAPI.LISTEN_BLOCK_INFO);
                    }
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.contains(player)) {
                        CrafttweakerImplementationAPI.blockInfoPlayers.remove(player);
                        player.sendChat("Block info mode deactivated.");
                    } else {
                        CrafttweakerImplementationAPI.blockInfoPlayers.add(player);
                        player.sendChat("Block info mode activated. Right-click a block to see its data.");
                    }
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.isEmpty()) {
                        CrafttweakerImplementationAPI.blockEventHandler.close();
                    }
                } else {
                    sender.sendMessage((ITextComponent)new TextComponentString("This Command can only be performed from a Player(InGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("copy"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct copy", "/ct copy", false), SpecialMessagesChat.getNormalMessage(" \u00a73Copies the provided string behind it"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                ClipboardHelper.copyCommandRun(sender, args);
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("nbt"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct nbt", "/ct nbt", true), SpecialMessagesChat.getNormalMessage(" \u00a73Shows the NBT of the block you are looking at"), SpecialMessagesChat.getNormalMessage(" \u00a73or the item you are holding"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender.getCommandSenderEntity();
                    ItemStack heldItem = player.getHeldItemMainhand();
                    if (heldItem != ItemStack.EMPTY) {
                        String itemName = "<" + heldItem.getItem().getRegistryName() + ":" + heldItem.getMetadata() + ">";
                        String nbt = "";
                        if (heldItem.serializeNBT().hasKey("tag")) {
                            nbt = NBTConverter.from(heldItem.serializeNBT().getTag("tag"), false).toString();
                        }
                        String withNBT = "";
                        if (nbt.length() > 0) {
                            withNBT = ".withTag(" + nbt + ")";
                        }
                        ClipboardHelper.copyStringPlayer(player, itemName + withNBT);
                        ClipboardHelper.sendMessageWithCopy(player, "Item \u00a72" + itemName, itemName + withNBT);
                        if (nbt.length() > 0) {
                            sender.sendMessage((ITextComponent)new TextComponentString("\u00a73NBT-Data:"));
                            ClipboardHelper.sendMessageWithCopy(player, NBTUtils.getAppealingString(nbt), nbt);
                        } else {
                            sender.sendMessage((ITextComponent)new TextComponentString("\u00a73No NBT Data"));
                        }
                    } else {
                        RayTraceResult rayTraceResult = CommandUtils.getPlayerLookat(player, 100.0);
                        if (rayTraceResult != null && rayTraceResult.typeOfHit == RayTraceResult.Type.BLOCK) {
                            BlockPos blockPos = rayTraceResult.getBlockPos();
                            IBlockState block = server.getEntityWorld().getBlockState(blockPos);
                            ClipboardHelper.sendMessageWithCopy(player, "Block \u00a72[" + block.getBlock().getRegistryName() + ":" + block.getBlock().getMetaFromState(block) + "] \u00a7rat \u00a79[" + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ() + "]\u00a7r", block.getBlock().getRegistryName() + ":" + block.getBlock().getMetaFromState(block));
                            TileEntity te = server.getEntityWorld().getTileEntity(blockPos);
                            if (te != null) {
                                sender.sendMessage((ITextComponent)new TextComponentString("\u00a73NBT-Data:"));
                                String nbt = NBTConverter.from((NBTBase)te.serializeNBT(), false).toString();
                                ClipboardHelper.sendMessageWithCopy(player, NBTUtils.getAppealingString(nbt), nbt);
                            } else {
                                sender.sendMessage((ITextComponent)new TextComponentString("\u00a73Block is no TileEntity and has no NBT"));
                            }
                        } else {
                            sender.sendMessage((ITextComponent)new TextComponentString("\u00a74Please hold an Item in your hand or look at a Block."));
                        }
                    }
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("log"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct log", "/ct log", true), SpecialMessagesChat.getNormalMessage(" \u00a73Sends a clickable link to open the crafttweaker.log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("", sender));
                } else {
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("Command must be executed as a Player (inGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("scripts"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct scripts", "/ct scripts", true), SpecialMessagesChat.getNormalMessage(" \u00a73Sends a clickable link to open the scripts directory"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.getCommandSenderEntity() instanceof EntityPlayer) {
                    sender.sendMessage(SpecialMessagesChat.getFileOpenText("Click to open the \u00a7a/scripts/ \u00a7rDirectory [\u00a76Click here to open\u00a7r]", new File("scripts/").getAbsolutePath()));
                } else {
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("Path to the scripts: " + new File("scripts/").getAbsolutePath()));
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("Command must be executed as a Player (inGame) to be clickable"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("syntax"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct syntax", "/ct syntax", true), SpecialMessagesChat.getNormalMessage(" \u00a73Checks the Syntax of the scripts"), SpecialMessagesChat.getNormalMessage(" \u00a73To see the effect you have to restart the game"), SpecialMessagesChat.getNormalMessage(" \u00a73Will print errors of the Bracket Handler"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length > 0 && args[0].equals("debug")) {
                    CraftTweakerAPI.tweaker.enableDebug();
                }
                sender.sendMessage(SpecialMessagesChat.getNormalMessage("\u00a7bBeginning load of the scripts"));
                ArrayList<ScriptLoader> erroredLoaders = new ArrayList<ScriptLoader>();
                for (ScriptLoader loader : CraftTweakerAPI.tweaker.getLoaders()) {
                    CraftTweakerAPI.tweaker.loadScript(true, loader);
                    if (loader.getLoaderStage() != ScriptLoader.LoaderStage.ERROR) continue;
                    erroredLoaders.add(loader);
                }
                if (erroredLoaders.isEmpty()) {
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("Syntax of scripts is \u00a7acorrect\u00a7r, to see the effect \u00a7erestart the game"));
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("Please be advised that \u00a7bbrackets (<>) \u00a7rmay have \u00a74errored, see above."));
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("If no errors appeared above everything was fine."));
                } else {
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage("These loaders failed to load correctly:"));
                    sender.sendMessage(SpecialMessagesChat.getNormalMessage(erroredLoaders.stream().map(ScriptLoader::getMainName).collect(Collectors.joining(", "))));
                    sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("\u00a74Syntax of the scripts is incorrect!", sender));
                }
            }

            @Override
            public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                ArrayList<String> commands = new ArrayList<String>(1);
                commands.add("debug");
                return commands;
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("zslint"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct zslint", "/ct zslint", true), SpecialMessagesChat.getNormalMessage(" \u00a73Starts the ZsLint socket."));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.sendMessage(SpecialMessagesChat.getNormalMessage("\u00a7bStarting socket."));
                CrTSocketHandler.enableSocket();
            }
        });
        CTChatCommand.registerCommand(new GiveCommand());
        CTChatCommand.registerCommand(new DumpZsCommand(new TargetLog(), new TargetHtml(), new TargetJson()));
        CTChatCommand.registerCommand(new HelpCommand());
        CTChatCommand.registerCommand(new NamesCommand());
        CTChatCommand.registerCommand(new CraftTweakerCommand("keyNames"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand((String)"\"KeyName\" -> keyCode");
                Field[] fields = Keyboard.class.getFields();
                try {
                    for (Field field : fields) {
                        if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith("KEY_") || field.getName().endsWith("WIN")) continue;
                        int key = field.getInt(null);
                        String name = field.getName().substring(4);
                        CraftTweakerAPI.logCommand((String)("\"" + name + "\" -> " + key));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sender.sendMessage(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Key names generated", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct keyNames", "/ct keyNames", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all LWJGL keynames to their respective KeyCodes in the game to the crafttweaker.log"));
            }
        });
    }

    private static class PotionComparator
    implements Comparator<IPotion>,
    Serializable {
        private static final long serialVersionUID = -56375350098392167L;

        private PotionComparator() {
        }

        @Override
        public int compare(IPotion o1, IPotion o2) {
            return o1.name().compareTo(o2.name());
        }
    }

    private static class ItemComparator
    implements Comparator<Item>,
    Serializable {
        private static final long serialVersionUID = 5425653624832997108L;

        private ItemComparator() {
        }

        @Override
        public int compare(Item o1, Item o2) {
            return o1.getRegistryName().toString().compareTo(o2.getRegistryName().toString());
        }
    }
}

