/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import crafttweaker.api.entity.IEntity;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IRayTraceResult;
import java.util.Objects;
import net.minecraft.util.math.RayTraceResult;

public class MCRayTraceResult
implements IRayTraceResult {
    private final RayTraceResult traceResult;

    public MCRayTraceResult(RayTraceResult traceResult) {
        this.traceResult = traceResult;
    }

    public boolean isMiss() {
        return this.traceResult.typeOfHit == RayTraceResult.Type.MISS;
    }

    public boolean isEntity() {
        return this.traceResult.typeOfHit == RayTraceResult.Type.ENTITY;
    }

    public boolean isBlock() {
        return this.traceResult.typeOfHit == RayTraceResult.Type.BLOCK;
    }

    public IEntity getEntity() {
        return CraftTweakerMC.getIEntity(this.traceResult.entityHit);
    }

    public IBlockPos getBlockPos() {
        return CraftTweakerMC.getIBlockPos(this.traceResult.getBlockPos());
    }

    public IFacing getSideHit() {
        return CraftTweakerMC.getIFacing(this.traceResult.sideHit);
    }

    public RayTraceResult getInternal() {
        return this.traceResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCRayTraceResult that = (MCRayTraceResult)o;
        return Objects.equals(this.traceResult, that.traceResult);
    }

    public int hashCode() {
        return Objects.hash(this.traceResult);
    }
}

