/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ctgui.api;

import com.blamejared.ctgui.api.SlotRecipeOutput;
import crafttweaker.api.data.IData;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class SlotRecipe
extends Slot {
    private Map<String, Boolean> propertyMap = new HashMap<String, Boolean>();
    private Map<String, Integer> properties = new HashMap<String, Integer>();

    public SlotRecipe(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public ItemStack onTake(EntityPlayer playerIn, ItemStack stack) {
        this.propertyMap.clear();
        this.properties.clear();
        return super.onTake(playerIn, stack);
    }

    public int getSlotStackLimit() {
        return 1;
    }

    public boolean isItemValid(@Nullable ItemStack stack) {
        return true;
    }

    public String getItemString() {
        IData data;
        boolean matchAny = this.getPropertyFromMap("matchNotEmpty");
        boolean metaWildcard = this.getPropertyFromMap("anyMetadata");
        boolean oreDict = this.getPropertyFromMap("oreDictionary");
        if (this.getStack().isEmpty()) {
            return "null";
        }
        String stackName = ((ResourceLocation)Item.REGISTRY.getNameForObject((Object)this.getStack().getItem())).toString();
        StringBuilder builder = new StringBuilder("<");
        if (oreDict) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)this.getStack());
            if (ids.length != 0) {
                stackName = "ore:" + OreDictionary.getOreName((int)ids[0]);
            } else {
                oreDict = false;
            }
        }
        if (matchAny) {
            stackName = "*";
        }
        builder.append(stackName);
        if (!(oreDict || matchAny || !metaWildcard && this.getStack().getItemDamage() == 0)) {
            builder.append(':').append(metaWildcard || this.getStack().getItemDamage() == Short.MAX_VALUE ? "*" : Integer.valueOf(this.getStack().getItemDamage()));
        }
        builder.append('>');
        if (this.getPropertyFromMap("anyDamage")) {
            builder.append(".anyDamage()");
        }
        if (this.getPropertyFromMap("onlyDamage")) {
            builder.append(".onlyDamaged()");
        }
        if (this.getPropertyFromMap("gted")) {
            builder.append(".onlyDamageAtLeast(").append(this.getProperty("gted")).append(')');
        }
        if (this.getPropertyFromMap("ltd")) {
            builder.append(".onlyDamageAtMost(").append(this.getProperty("ltd")).append(')');
        }
        if (this.getPropertyFromMap("betweenDamage")) {
            builder.append(".onlyDamageBetween(").append(this.getProperty("betweenDamageX")).append(", ").append(this.getProperty("betweenDamageY")).append(')');
        }
        if (this.getPropertyFromMap("noreturn")) {
            builder.append(".noReturn()");
        }
        if (this.getPropertyFromMap("nbt") && (data = NBTConverter.from((NBTBase)this.getStack().getTagCompound(), false)) != null) {
            builder.append(String.format(".withTag(%s)", data.toString()));
            if (!(this instanceof SlotRecipeOutput)) {
                builder.append(String.format(".onlyWithTag(%s)", data.toString()));
            }
        }
        if (this.getStack().getCount() > 1) {
            builder.append(" * ").append(this.getStack().getCount());
        }
        return builder.toString();
    }

    boolean getPropertyFromMap(String key) {
        if (this.propertyMap.containsKey(key)) {
            return this.propertyMap.get(key);
        }
        return false;
    }

    int getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return 0;
    }

    public Map<String, Boolean> getPropertyMap() {
        return this.propertyMap;
    }

    public Map<String, Integer> getProperties() {
        return this.properties;
    }
}

