/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IDataConverter;
import crafttweaker.api.data.cast.DataConverterBool;
import crafttweaker.api.data.cast.DataConverterByteArray;
import crafttweaker.api.data.cast.DataConverterIntArray;
import crafttweaker.api.data.cast.DataConverterList;
import crafttweaker.api.data.cast.DataConverterMap;
import crafttweaker.api.data.cast.DataConverterNumber;
import crafttweaker.api.data.cast.DataConverterString;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMemberGetter;
import stanhebben.zenscript.annotations.ZenMemberSetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="crafttweaker.data.IData")
@ZenRegister
public interface IData {
    @ZenOperator(value=OperatorType.ADD)
    public IData add(IData var1);

    @ZenOperator(value=OperatorType.SUB)
    public IData sub(IData var1);

    @ZenOperator(value=OperatorType.MUL)
    public IData mul(IData var1);

    @ZenOperator(value=OperatorType.DIV)
    public IData div(IData var1);

    @ZenOperator(value=OperatorType.MOD)
    public IData mod(IData var1);

    @ZenOperator(value=OperatorType.AND)
    public IData and(IData var1);

    @ZenOperator(value=OperatorType.OR)
    public IData or(IData var1);

    @ZenOperator(value=OperatorType.XOR)
    public IData xor(IData var1);

    @ZenOperator(value=OperatorType.NEG)
    public IData neg();

    @ZenOperator(value=OperatorType.NOT)
    public IData not();

    @ZenCaster
    @ZenMethod
    default public boolean asBool() {
        return this.convert(DataConverterBool.INSTANCE).get();
    }

    @ZenCaster
    @ZenMethod
    default public byte asByte() {
        return this.convert(DataConverterNumber.INSTANCE).get().byteValue();
    }

    @ZenCaster
    @ZenMethod
    default public short asShort() {
        return this.convert(DataConverterNumber.INSTANCE).get().shortValue();
    }

    @ZenCaster
    @ZenMethod
    default public int asInt() {
        return this.convert(DataConverterNumber.INSTANCE).get().intValue();
    }

    @ZenCaster
    @ZenMethod
    default public long asLong() {
        return this.convert(DataConverterNumber.INSTANCE).get().longValue();
    }

    @ZenCaster
    @ZenMethod
    default public float asFloat() {
        return this.convert(DataConverterNumber.INSTANCE).get().floatValue();
    }

    @ZenCaster
    @ZenMethod
    default public double asDouble() {
        return this.convert(DataConverterNumber.INSTANCE).get().doubleValue();
    }

    @ZenCaster
    @ZenMethod
    default public String asString() {
        return this.convert(DataConverterString.INSTANCE).get();
    }

    @ZenCaster
    @ZenMethod
    default public List<IData> asList() {
        return this.convert(DataConverterList.INSTANCE).get();
    }

    @ZenCaster
    @ZenMethod
    default public Map<String, IData> asMap() {
        return this.convert(DataConverterMap.INSTANCE).get();
    }

    @ZenCaster
    @ZenMethod
    default public byte[] asByteArray() {
        return this.convert(DataConverterByteArray.INSTANCE).get();
    }

    @ZenCaster
    @ZenMethod
    default public int[] asIntArray() {
        return this.convert(DataConverterIntArray.INSTANCE).get();
    }

    @ZenOperator(value=OperatorType.INDEXGET)
    public IData getAt(int var1);

    @ZenOperator(value=OperatorType.INDEXSET)
    public void setAt(int var1, IData var2);

    @ZenMethod
    @ZenMemberGetter
    public IData memberGet(String var1);

    @ZenMethod
    @ZenMemberSetter
    public void memberSet(String var1, IData var2);

    @ZenGetter
    public int length();

    @ZenOperator(value=OperatorType.CONTAINS)
    public boolean contains(IData var1);

    @ZenOperator(value=OperatorType.COMPARE)
    public int compareTo(IData var1);

    @ZenOperator(value=OperatorType.EQUALS)
    public boolean equals(IData var1);

    @ZenGetter
    public IData immutable();

    @ZenMethod
    public IData update(IData var1);

    public <T> T convert(IDataConverter<T> var1);

    public String toString();
}

