/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data.cast;

import crafttweaker.api.data.IllegalDataException;

public interface CastResult<T> {
    public T get();

    public boolean isOk();

    public static <T> CastResult<T> ok(T value) {
        return new Ok<T>(value);
    }

    public static <T> CastResult<T> fail(String message) {
        return new Fail(message);
    }

    public static <T> CastResult<T> nil() {
        return Nil.INSTANCE;
    }

    public static enum Nil implements CastResult<Object>
    {
        INSTANCE;


        @Override
        public Object get() {
            return null;
        }

        @Override
        public boolean isOk() {
            return false;
        }
    }

    public static class Fail<T>
    implements CastResult<T> {
        private final String message;

        public Fail(String message) {
            this.message = message;
        }

        @Override
        public T get() {
            throw new IllegalDataException(this.message);
        }

        @Override
        public boolean isOk() {
            return false;
        }
    }

    public static class Ok<T>
    implements CastResult<T> {
        private final T value;

        public Ok(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isOk() {
            return true;
        }
    }
}

