/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data;

import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import crafttweaker.api.data.cast.CastResult;
import crafttweaker.api.data.cast.DataConverterString;
import java.util.List;
import java.util.Map;

public class DataString
implements IData {
    private final String value;

    public DataString(String value) {
        this.value = value;
    }

    @Override
    public IData getAt(int i) {
        return new DataString(this.value.substring(i, i + 1));
    }

    @Override
    public void setAt(int i, IData value) {
        throw new UnsupportedOperationException("Strings are immutable");
    }

    @Override
    public IData memberGet(String name) {
        if (name.equals("length")) {
            return new DataInt(this.value.length());
        }
        throw new UnsupportedOperationException("no such member: " + name);
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new UnsupportedOperationException("Strings are immutable");
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public boolean contains(IData data) {
        return this.equals(data);
    }

    @Override
    public boolean equals(IData data) {
        if (data instanceof DataString) {
            return this.value.equals(((DataString)data).value);
        }
        CastResult<String> result = data.convert(DataConverterString.INSTANCE);
        return result.isOk() && this.value.equals(result.get());
    }

    @Override
    public int compareTo(IData data) {
        return this.value.compareTo(data.asString());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromString(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataString(this.value + other.asString());
    }

    @Override
    public IData sub(IData other) {
        throw new UnsupportedOperationException("Cannot subtract from a string");
    }

    @Override
    public IData mul(IData other) {
        throw new UnsupportedOperationException("Cannot multiply a string");
    }

    @Override
    public IData div(IData other) {
        throw new UnsupportedOperationException("Cannot divide a string");
    }

    @Override
    public IData mod(IData other) {
        throw new UnsupportedOperationException("Cannot perform modulo on a string");
    }

    @Override
    public IData and(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData or(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData xor(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData neg() {
        throw new UnsupportedOperationException("Cannot negate a string");
    }

    @Override
    public IData not() {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public String toString() {
        return DataString.quoteAndEscape(this.value);
    }

    public static String quoteAndEscape(String p_193588_0_) {
        StringBuilder stringbuilder = new StringBuilder("\"");
        for (int i = 0; i < p_193588_0_.length(); ++i) {
            char c0 = p_193588_0_.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.append('\"').toString();
    }

    @Override
    public boolean asBool() {
        return IData.super.asBool();
    }

    @Override
    public byte asByte() {
        return IData.super.asByte();
    }

    @Override
    public short asShort() {
        return IData.super.asShort();
    }

    @Override
    public int asInt() {
        return IData.super.asInt();
    }

    @Override
    public long asLong() {
        return IData.super.asLong();
    }

    @Override
    public float asFloat() {
        return IData.super.asFloat();
    }

    @Override
    public double asDouble() {
        return IData.super.asDouble();
    }

    @Override
    public String asString() {
        return IData.super.asString();
    }

    @Override
    public List<IData> asList() {
        return IData.super.asList();
    }

    @Override
    public Map<String, IData> asMap() {
        return IData.super.asMap();
    }

    @Override
    public byte[] asByteArray() {
        return IData.super.asByteArray();
    }

    @Override
    public int[] asIntArray() {
        return IData.super.asIntArray();
    }
}

