package crafttweaker.api.chat;

import crafttweaker.annotations.ZenRegister;
import stanhebben.zenscript.annotations.*;

/**
 * Represents a chat message. Strings can be converted into chat messages, and
 * chat messages can be colored and concatenated.
 *
 * @author Stan Hebben
 */
@ZenClass("crafttweaker.chat.IChatMessage")
@ZenRegister
public interface IChatMessage {
    
    /**
     * Concatenates two chat messages.
     *
     * @param other other chat message
     *
     * @return concatenated chat message
     */
    @ZenOperator(OperatorType.ADD)
    IChatMessage add(IChatMessage other);
    
    /**
     * Retrieves the internal object backing this object. Must be generated by
     * the implementing platform.
     *
     * @return internal object
     */
    Object getInternal();
}
