package com.blamejared.contenttweaker.fabric.registry;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import net.minecraft.class_2378;

public final class FabricRegistrationManager {
    private FabricRegistrationManager() {}

    public static void registerAll(final class_2378<? extends class_2378<?>> registry) {
        registry.iterator().forEachRemaining(FabricRegistrationManager::registerAndFreeze);
        ContentTweakerCore.LOGGER.info("Registries frozen");
    }

    private static <T> void registerAndFreeze(final class_2378<T> registry) {
        registerFor(registry);
        registry.method_40276();
    }

    private static <T> void registerFor(final class_2378<T> registry) {
        final ObjectType<T> type = ContentTweakerCore.core().metaRegistry().objectTypes().get(registry.method_30517());
        if (type == null) {
            ContentTweakerCore.LOGGER.info("Unknown registry '{}': are you missing object types for it?", registry.method_30517());
            return;
        }
        ContentTweakerCore.LOGGER.info("Registering objects for type '{}'", type);
        try {
            FabricGameRegistry.of(registry, type).doRegistration();
        } catch (final Throwable e) {
            CraftTweakerAPI.LOGGER.error("A critical internal ContentTweaker error occurred", e);
            ContentTweakerCore.LOGGER.error("A critical internal ContentTweaker error occurred", e);
        }
    }
}
