package com.blamejared.contenttweaker.fabric.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class FabricGameRegistry<T> implements GameRegistry<T> {
    private static final Map<ObjectType<?>, FabricGameRegistry<?>> INSTANCES = new HashMap<>();

    private final class_2378<T> registry;
    private final ObjectType<T> type;
    private final List<Runnable> commands;

    private FabricGameRegistry(final class_2378<T> registry, final ObjectType<T> type) {
        this.registry = registry;
        this.type = type;
        this.commands = new ArrayList<>();
    }

    public static <T> FabricGameRegistry<T> of(final class_2378<T> registry, final ObjectType<T> type) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(type, "type");
        return GenericUtil.uncheck(INSTANCES.computeIfAbsent(type, it -> new FabricGameRegistry<>(registry, type)));
    }

    @Override
    public ObjectType<T> type() {
        return this.type;
    }

    @Override
    public T get(final class_2960 name) {
        return this.registry.method_10223(Objects.requireNonNull(name));
    }

    @Override
    public class_2960 nameOf(final T object) {
        return this.registry.method_10221(Objects.requireNonNull(object));
    }

    @Override
    public Collection<T> all() {
        return this.stream().toList();
    }

    @Override
    public void enqueueRegistration(final class_2960 name, final Supplier<T> object) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(object, "object");
        this.commands.add(() -> class_2378.method_10230(this.registry, name, Objects.requireNonNull(object.get(), "get")));
    }

    @Override
    public Stream<T> stream() {
        return this.registry.method_10220();
    }

    public void doRegistration() {
        this.commands.forEach(Runnable::run);
        this.commands.clear();
    }

    @Override
    public String toString() {
        return "%s[%s]{%s}".formatted(this.registry.method_30517().method_29177(), this.type, this.registry);
    }
}
