#loader contenttweaker

/**********************************************************************************************************************/
/*                                                      RESOURCES                                                     */
/**********************************************************************************************************************/

// Last but not least, almost every object requires some resources to behave properly. For example, items require
// textures, models, and names; blocks do too, with the addition of loot tables...

// You don't have to write any of that yourself, though. ContentTweaker is able to generate all of that by itself
// already. You can then freely replace anything you don't like, such as textures, through a resource pack. Let's
// explain how this works a little better.

// Whenever you create an object, ContentTweaker will also create all resources required by the object you created.
// These resources will follow some basic templates that provide only basic functionality, leaving you complete freedom
// in case you want more, but also avoiding the tedium of creating useless fluff yourself.
// "But where are these things generated?" I hear you ask. The answer is that they are generated at runtime and stored
// directly in memory. This ensures that what we provide is **always** the more correct set of data for what you might
// want to achieve. And it also let's us fix bugs in case something weird happens.
// At the same time, we also provide the "resources" directory. That directory is an implicit resource pack and data
// pack which will be applied globally. Everything you put in there will automatically override anything done by us, no
// other mods required!

// For example, let's say you create an item, and you want to give it a custom texture. You can place the texture in the
// correct spot inside the `resources` directory, and YOUR texture will be used instead of the default one provided by
// us. You don't have to provide a model or anything else: it'll just work.

// We do recognize that some people might want to know what data is being generated by us, either because they're
// curious or because they want to use it as an example structure. For this reason, using the command
// `/ct dump contenttweaker_resources file` will dump everything we created into "ct_dumps/contenttweaker_resources".
// What you'll get is a ready-made resource and data pack, which you are free to use as you desire.

// Nevertheless, what ContentTweaker uses is the normal resource and data pack system, so if you want to customize any
// of those resources, you should look into the resources provided by vanilla and on the Minecraft wiki over on Fandom.
