/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.object.property;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.ContentTweakerVanillaApi;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.zen.object.BlockReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.MaterialColorReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockPropertyFunctions;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.object.vanilla.property.StandardBlockProperties")
@ZenRegister(loaders={"contenttweaker"})
public final class StandardBlockProperties
extends BlockProperties {
    public StandardBlockProperties(BlockReference reference) {
        super(reference, "standard");
    }

    public SimpleReference<class_3614> material() {
        class_3614 material = this.resolveProperties().material();
        return SimpleReference.of(VanillaObjectTypes.MATERIAL, this.nameOf(VanillaObjectTypes.MATERIAL, material));
    }

    public BlockPropertyFunctions.MaterialColorFinder materialColor() {
        return this.resolveProperties().materialColor().andThen(it -> this.nameOf(VanillaObjectTypes.MATERIAL_COLOR, it)).andThen(MaterialColorReference::of)::apply;
    }

    public boolean hasCollision() {
        return this.resolveProperties().hasCollision();
    }

    public SimpleReference<class_2498> soundType() {
        class_2498 type = this.resolveProperties().soundType();
        return SimpleReference.of(VanillaObjectTypes.SOUND_TYPE, this.nameOf(VanillaObjectTypes.SOUND_TYPE, type));
    }

    public BlockPropertyFunctions.LightLevelComputer lightEmission() {
        return this.resolveProperties().lightEmission()::applyAsInt;
    }

    public float explosionResistance() {
        return this.resolve().method_9520();
    }

    public float destroyTime() {
        return this.resolve().method_36555();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.resolveProperties().requiresCorrectToolForDrops();
    }

    public boolean isRandomlyTicking() {
        return this.resolveProperties().isRandomlyTicking();
    }

    public float friction() {
        return this.resolve().method_9499();
    }

    public float speedFactor() {
        return this.resolve().method_23349();
    }

    public float jumpFactor() {
        return this.resolve().method_23350();
    }

    public class_2960 drops() {
        return this.resolve().method_26162();
    }

    public boolean canOcclude() {
        return this.resolveProperties().canOcclude();
    }

    public boolean isAir() {
        return this.resolveProperties().isAir();
    }

    public boolean dynamicShape() {
        return this.resolve().method_9543();
    }

    private VanillaAdapter resolveProperties() {
        return ContentTweakerVanillaApi.get().blockPropertiesAdapterOf(this.resolve());
    }

    private <T> class_2960 nameOf(ObjectType<T> type, T thing) {
        return ContentTweakerApi.get().registry().findResolver(type).nameOf(thing);
    }

    public static interface VanillaAdapter {
        public class_3614 material();

        public Function<class_2680, class_3620> materialColor();

        public boolean hasCollision();

        public class_2498 soundType();

        public ToIntFunction<class_2680> lightEmission();

        public boolean requiresCorrectToolForDrops();

        public boolean isRandomlyTicking();

        public boolean canOcclude();

        public boolean isAir();
    }
}

