/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.factory;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectFactory;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.registry.CreativeTabRegistry;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.util.CustomCreativeTab;
import com.blamejared.contenttweaker.vanilla.api.zen.object.CreativeTabReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.factory.vanilla.CreativeTabFactory")
@ZenRegister(loaders={"contenttweaker"})
public final class CreativeTabFactory
implements ObjectFactory<class_1761> {
    @Override
    public ObjectType<class_1761> type() {
        return VanillaObjectTypes.CREATIVE_TAB;
    }

    @ZenCodeType.Method(value="create")
    public CreativeTabReference create(String id, ItemReference icon) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(icon);
        class_2960 registryId = CreativeTabRegistry.fromId(id);
        ObjectHolder<class_1761> holder = ObjectHolder.of(this.type(), registryId, () -> CustomCreativeTab.of(id, icon));
        ContentTweakerApi.apply(RegisterObjectAction.of(holder, resource -> this.provideResources((ResourceManager)resource, id)));
        return CreativeTabReference.of(id);
    }

    private void provideResources(ResourceManager manager, String id) {
        ResourceFragment assets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        assets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.tab(id, "Custom Tab"), Language.SERIALIZER);
    }
}

