/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.sound;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.util.ReferencingSoundType;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.sound.SoundTypeBuilder")
@ZenRegister(loaders={"contenttweaker"})
public final class SoundTypeBuilder {
    private Float volume = null;
    private Float pitch = null;
    private SimpleReference<class_3414> breakSound = null;
    private SimpleReference<class_3414> stepSound = null;
    private SimpleReference<class_3414> placeSound = null;
    private SimpleReference<class_3414> hitSound = null;
    private SimpleReference<class_3414> fallSound = null;

    private SoundTypeBuilder() {
    }

    public static SoundTypeBuilder of() {
        return new SoundTypeBuilder();
    }

    @ZenCodeType.Method(value="volume")
    public SoundTypeBuilder volume(float volume) {
        this.volume = Float.valueOf(volume);
        return this;
    }

    @ZenCodeType.Method(value="pitch")
    public SoundTypeBuilder pitch(float pitch) {
        this.pitch = Float.valueOf(pitch);
        return this;
    }

    @ZenCodeType.Method(value="breakSound")
    public SoundTypeBuilder breakSound(SimpleReference<class_3414> sound) {
        this.breakSound = Objects.requireNonNull(sound);
        return this;
    }

    @ZenCodeType.Method(value="stepSound")
    public SoundTypeBuilder stepSound(SimpleReference<class_3414> sound) {
        this.stepSound = Objects.requireNonNull(sound);
        return this;
    }

    @ZenCodeType.Method(value="placeSound")
    public SoundTypeBuilder placeSound(SimpleReference<class_3414> sound) {
        this.placeSound = Objects.requireNonNull(sound);
        return this;
    }

    @ZenCodeType.Method(value="hitSound")
    public SoundTypeBuilder hitSound(SimpleReference<class_3414> sound) {
        this.hitSound = Objects.requireNonNull(sound);
        return this;
    }

    @ZenCodeType.Method(value="fallSound")
    public SoundTypeBuilder fallSound(SimpleReference<class_3414> sound) {
        this.fallSound = Objects.requireNonNull(sound);
        return this;
    }

    @ZenCodeType.Method(value="build")
    public SimpleReference<class_2498> build(String name) {
        if (this.volume == null) {
            throw new IllegalStateException("Missing volume specification for sound type builder");
        }
        if (this.pitch == null) {
            throw new IllegalStateException("Missing pitch specification for sound type builder");
        }
        if (this.breakSound == null) {
            throw new IllegalStateException("Missing break sound specification for sound type builder");
        }
        if (this.stepSound == null) {
            throw new IllegalStateException("Missing step sound specification for sound type builder");
        }
        if (this.placeSound == null) {
            throw new IllegalStateException("Missing place sound specification for sound type builder");
        }
        if (this.hitSound == null) {
            throw new IllegalStateException("Missing hit sound specification for sound type builder");
        }
        if (this.fallSound == null) {
            throw new IllegalStateException("Missing fall sound specification for sound type builder");
        }
        class_2960 id = ContentTweakerConstants.rl(name);
        ObjectHolder<class_2498> holder = ObjectHolder.of(VanillaObjectTypes.SOUND_TYPE, id, this::create);
        ContentTweakerApi.apply(RegisterObjectAction.of(holder));
        return SimpleReference.of(VanillaObjectTypes.SOUND_TYPE, id);
    }

    private class_2498 create() {
        return ReferencingSoundType.of(this.volume.floatValue(), this.pitch.floatValue(), this.breakSound, this.stepSound, this.placeSound, this.hitSound, this.fallSound);
    }
}

