/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.sound;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.resource.SoundDefinition;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.NameUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.sound.SoundEventBuilder")
@ZenRegister(loaders={"contenttweaker"})
public final class SoundEventBuilder {
    private final String id;
    private boolean exampleSet;

    private SoundEventBuilder(String id) {
        this.id = id;
        this.exampleSet = true;
    }

    public static SoundEventBuilder of(String id) {
        return new SoundEventBuilder(Objects.requireNonNull(id));
    }

    @ZenCodeType.Method(value="build")
    public SimpleReference<class_3414> build(@ZenCodeType.Optional @ZenCodeType.Nullable String name) {
        class_2960 soundId = ContentTweakerConstants.rl(NameUtil.fixing((String)this.id));
        class_2960 registryId = ContentTweakerConstants.rl(name == null ? this.id : name);
        ObjectHolder<class_3414> eventHolder = ObjectHolder.of(VanillaObjectTypes.SOUND_EVENT, registryId, () -> new class_3414(soundId));
        ContentTweakerApi.apply(RegisterObjectAction.of(eventHolder, manager -> this.generateResources(soundId, this.exampleSet, (ResourceManager)manager)));
        return SimpleReference.of(VanillaObjectTypes.SOUND_EVENT, registryId);
    }

    private void generateResources(class_2960 soundId, boolean exampleSet, ResourceManager manager) {
        BiConsumer<class_2960, ResourceManager> generator = exampleSet ? this::generateExampleResources : this::generateSpecifiedResources;
        generator.accept(soundId, manager);
    }

    private void generateExampleResources(class_2960 soundId, ResourceManager manager) {
        ResourceFragment assets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        assets.provideOrAlter("sounds.json", SoundDefinition::of, it -> this.makeDefinition((SoundDefinition)it, soundId), SoundDefinition.SERIALIZER);
        assets.provideTemplated(PathHelper.sound(soundId), "sound/what_is.ogg");
    }

    private void generateSpecifiedResources(class_2960 soundId, ResourceManager manager) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private SoundDefinition makeDefinition(SoundDefinition definition, class_2960 id) {
        return definition.add(id).sound(id).finish().finish();
    }
}

