/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.material;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.material.MaterialBuilder")
@ZenRegister(loaders={"contenttweaker"})
public final class MaterialBuilder {
    private final Reference<class_3620> color;
    private class_3619 pushReaction;
    private boolean blocksMotion;
    private boolean flammable;
    private boolean liquid;
    private boolean replaceable;
    private boolean solid;
    private boolean solidBlocking;

    private MaterialBuilder(Reference<class_3620> reference) {
        this.color = reference;
        this.pushReaction = null;
        this.blocksMotion = false;
        this.flammable = false;
        this.liquid = false;
        this.replaceable = false;
        this.solid = false;
        this.solidBlocking = false;
    }

    public static MaterialBuilder of(Reference<class_3620> reference) {
        return new MaterialBuilder(Objects.requireNonNull(reference));
    }

    @ZenCodeType.Method(value="pushReaction")
    public MaterialBuilder pushReaction(class_3619 reaction) {
        this.pushReaction = Objects.requireNonNull(reaction);
        return this;
    }

    @ZenCodeType.Method(value="blocksMotion")
    public MaterialBuilder blocksMotion() {
        this.blocksMotion = true;
        return this;
    }

    @ZenCodeType.Method(value="flammable")
    public MaterialBuilder flammable() {
        this.flammable = true;
        return this;
    }

    @ZenCodeType.Method(value="liquid")
    public MaterialBuilder liquid() {
        this.liquid = true;
        return this;
    }

    @ZenCodeType.Method(value="replaceable")
    public MaterialBuilder replaceable() {
        this.replaceable = true;
        return this;
    }

    @ZenCodeType.Method(value="solid")
    public MaterialBuilder solid() {
        this.solid = true;
        return this;
    }

    @ZenCodeType.Method(value="solidBlocking")
    public MaterialBuilder solidBlocking() {
        this.solidBlocking = true;
        return this;
    }

    @ZenCodeType.Method(value="build")
    public SimpleReference<class_3614> build(String name) {
        class_2960 id = ContentTweakerConstants.rl(name);
        ObjectHolder<class_3614> holder = ObjectHolder.of(VanillaObjectTypes.MATERIAL, id, this::make);
        ContentTweakerApi.apply(RegisterObjectAction.of(holder));
        return SimpleReference.of(VanillaObjectTypes.MATERIAL, id);
    }

    private class_3614 make() {
        return new class_3614(this.color.get(), this.liquid, this.solid, this.blocksMotion, this.solidBlocking, this.flammable, this.replaceable, Optional.ofNullable(this.pushReaction).orElse(class_3619.field_15974));
    }
}

