/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.resource.Tag;
import com.blamejared.contenttweaker.vanilla.api.zen.ContentTweakerVanillaConstants;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ToolItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.CustomTool")
@ZenRegister(loaders={"contenttweaker"})
public final class CustomToolItemBuilder
extends ToolItemBuilder<CustomToolItemBuilder> {
    private class_2960 tag = null;

    public CustomToolItemBuilder(BiFunction<ObjectHolder<? extends class_1792>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @ZenCodeType.Method(value="tag")
    public CustomToolItemBuilder tag(class_2960 tag) {
        this.tag = Objects.requireNonNull(tag);
        return this;
    }

    @Override
    public ObjectHolder<? extends class_1792> createTool(class_2960 name, ToolItemBuilder.ToolData toolData, Supplier<class_1792.class_1793> builtProperties) {
        if (this.tag == null) {
            throw new IllegalStateException("Unable to create a custom tool without a tag for blocks to mine");
        }
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> new CustomDiggerItem(toolData, this.tag, builtProperties));
    }

    @Override
    public void provideResources(class_2960 name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceFragment cotData = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_DATA);
        class_2960 texture = new class_2960(name.method_12836(), "item/%s".formatted(name.method_12832()));
        cotAssets.provideTemplated(PathHelper.texture(texture), ContentTweakerVanillaConstants.itemTemplate("item"));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.of(new class_2960("item/handheld")).layer(0, texture), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Tool"), Language.SERIALIZER);
        cotData.provideOrAlter(PathHelper.tag(VanillaObjectTypes.BLOCK, this.tag), Tag::of, Function.identity(), Tag.SERIALIZER);
    }

    private static final class CustomDiggerItem
    extends class_1766 {
        CustomDiggerItem(ToolItemBuilder.ToolData data, class_2960 tag, Supplier<class_1792.class_1793> properties) {
            super(data.baseAttackDamage(), data.attackSpeed(), data.tier().get(), class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)tag), properties.get());
        }
    }
}

