/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;

public final class Tag {
    public static final ResourceSerializer<Tag> SERIALIZER = Tag::serialize;
    private final Set<Entry> entries = new HashSet<Entry>();

    private Tag() {
    }

    public static Tag of() {
        return new Tag();
    }

    public Tag addObject(class_2960 location) {
        return this.add(Entry.object(location));
    }

    public Tag addTag(class_2960 location) {
        return this.add(Entry.tag(location));
    }

    private Tag add(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    private byte[] serialize() {
        JsonArray values = new JsonArray();
        this.entries.stream().map(Entry::serialize).forEach(arg_0 -> ((JsonArray)values).add(arg_0));
        JsonObject object = new JsonObject();
        object.add("values", (JsonElement)values);
        object.add("replace", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }

    private record Entry(class_2960 location, Type type) {
        static Entry object(class_2960 location) {
            return new Entry(Objects.requireNonNull(location), Type.OBJECT);
        }

        static Entry tag(class_2960 location) {
            return new Entry(Objects.requireNonNull(location), Type.TAG);
        }

        JsonElement serialize() {
            return new JsonPrimitive("%s%s".formatted(this.type() == Type.TAG ? "#" : "", this.location()));
        }

        static enum Type {
            OBJECT,
            TAG;

        }
    }
}

