/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public final class PathHelper {
    private static final Supplier<Map<ObjectType<?>, String>> SPECIAL_TAGS = Suppliers.memoize(() -> Map.of(VanillaObjectTypes.BLOCK, "blocks", VanillaObjectTypes.ITEM, "items"));

    private PathHelper() {
    }

    public static String blockLootTable(class_2960 name) {
        return PathHelper.lootTable(new class_2960(Objects.requireNonNull(name).method_12836(), "blocks/%s".formatted(name.method_12832())));
    }

    public static String blockModel(class_2960 name) {
        return "models/block/%s.json".formatted(Objects.requireNonNull(name).method_12832());
    }

    public static String blockState(class_2960 name) {
        return "blockstates/%s.json".formatted(Objects.requireNonNull(name).method_12832());
    }

    public static String itemModel(class_2960 name) {
        return "models/item/%s.json".formatted(Objects.requireNonNull(name).method_12832());
    }

    public static String lang(String language) {
        return "lang/%s.json".formatted(Objects.requireNonNull(language));
    }

    public static String lootTable(class_2960 table) {
        return "loot_tables/%s.json".formatted(Objects.requireNonNull(table).method_12832());
    }

    public static String sound(class_2960 id) {
        return "sounds/%s.ogg".formatted(Objects.requireNonNull(id).method_12832());
    }

    public static String texture(class_2960 name) {
        return "textures/%s.png".formatted(Objects.requireNonNull(name).method_12832());
    }

    public static String tag(ObjectType<?> type, class_2960 name) {
        String path = SPECIAL_TAGS.get().containsKey(Objects.requireNonNull(type)) ? SPECIAL_TAGS.get().get(type) : Objects.requireNonNull(type.key()).method_29177().method_12832();
        return "tags/%s/%s.json".formatted(path, Objects.requireNonNull(name).method_12832());
    }

    public static String usLang() {
        return PathHelper.lang("en_us");
    }
}

