/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public final class LootTable {
    public static final ResourceSerializer<LootTable> SERIALIZER = LootTable::serialize;
    private final class_2960 type;
    private final List<LootFunction> functions;
    private final List<LootPool> pools;

    private LootTable(class_2960 type) {
        this.type = type;
        this.functions = new ArrayList<LootFunction>();
        this.pools = new ArrayList<LootPool>();
    }

    public static LootTable of(class_2960 type) {
        return new LootTable(Objects.requireNonNull(type));
    }

    public static LootTable ofBlock() {
        return new LootTable(new class_2960("block"));
    }

    public static LootTable ofChest() {
        return new LootTable(new class_2960("chest"));
    }

    public static LootTable ofEmpty() {
        return new LootTable(null);
    }

    public static LootTable ofEntity() {
        return new LootTable(new class_2960("entity"));
    }

    public static LootTable ofFishing() {
        return new LootTable(new class_2960("fishing"));
    }

    public static LootTable ofGeneric() {
        return new LootTable(new class_2960("generic"));
    }

    public LootTable function(class_2960 type, JsonObject parameters) {
        this.functions.add(new LootFunction(Objects.requireNonNull(type), Objects.requireNonNull(parameters)));
        return this;
    }

    public LootPoolBuilder pool() {
        return new LootPoolBuilder(this);
    }

    LootTable pool(LootPool pool) {
        this.pools.add(pool);
        return this;
    }

    private byte[] serialize() {
        JsonObject object = new JsonObject();
        if (this.type != null) {
            object.addProperty("type", this.type.toString());
        }
        if (!this.functions.isEmpty()) {
            JsonArray functions = new JsonArray();
            this.functions.stream().map(TypeParametersSerializable::serialize).forEach(arg_0 -> ((JsonArray)functions).add(arg_0));
            object.add("functions", (JsonElement)functions);
        }
        if (!this.pools.isEmpty()) {
            JsonArray pools = new JsonArray();
            this.pools.stream().map(LootPool::serialize).forEach(arg_0 -> ((JsonArray)pools).add(arg_0));
            object.add("pools", (JsonElement)pools);
        }
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }

    private record LootFunction(class_2960 type, JsonObject parameters) implements TypeParametersSerializable
    {
    }

    public static final class LootPoolBuilder {
        private final LootTable parent;
        private final List<LootCondition> conditions;
        private final List<LootFunction> functions;
        private final List<LootEntry> entries;
        private LootNumber rolls;
        private LootNumber bonus;

        LootPoolBuilder(LootTable parent) {
            this.parent = parent;
            this.conditions = new ArrayList<LootCondition>();
            this.functions = new ArrayList<LootFunction>();
            this.entries = new ArrayList<LootEntry>();
            this.rolls = null;
            this.bonus = null;
        }

        public LootPoolBuilder conditionally(class_2960 type, JsonObject parameters) {
            this.conditions.add(new LootCondition(Objects.requireNonNull(type), Objects.requireNonNull(parameters)));
            return this;
        }

        public LootPoolBuilder function(class_2960 type, JsonObject parameters) {
            this.functions.add(new LootFunction(Objects.requireNonNull(type), Objects.requireNonNull(parameters)));
            return this;
        }

        public LootPoolBuilder rolls(int rolls) {
            if (this.rolls != null) {
                throw new IllegalStateException("Already specified rolls");
            }
            if (rolls < 0) {
                throw new IllegalArgumentException("Rolls must be positive");
            }
            this.rolls = new LootNumber(rolls, null, null, null);
            return this;
        }

        public LootPoolBuilder rolls(class_2960 type, JsonObject parameters) {
            if (this.rolls != null) {
                throw new IllegalStateException("Already specified rolls");
            }
            this.rolls = new LootNumber(null, null, Objects.requireNonNull(type), Objects.requireNonNull(parameters));
            return this;
        }

        public LootPoolBuilder bonusRolls(float rolls) {
            if (this.bonus != null) {
                throw new IllegalStateException("Already specified rolls");
            }
            if (rolls < 0.0f) {
                throw new IllegalArgumentException("Rolls must be positive");
            }
            this.bonus = new LootNumber(null, Float.valueOf(rolls), null, null);
            return this;
        }

        public LootPoolBuilder bonusRolls(class_2960 type, JsonObject parameters) {
            if (this.bonus != null) {
                throw new IllegalStateException("Already specified rolls");
            }
            this.bonus = new LootNumber(null, null, Objects.requireNonNull(type), Objects.requireNonNull(parameters));
            return this;
        }

        public LootEntryBuilder<LootPoolBuilder, ParentAdapter> entry(class_2960 type) {
            return new LootEntryBuilder<LootPoolBuilder, ParentAdapter>(new ParentAdapter(this), Objects.requireNonNull(type));
        }

        public LootTable finish() {
            return this.parent.pool(new LootPool(new ArrayList<LootCondition>(this.conditions), new ArrayList<LootFunction>(this.functions), this.rolls, this.bonus, new ArrayList<LootEntry>(this.entries)));
        }

        LootPoolBuilder entry(LootEntry entry) {
            this.entries.add(entry);
            return this;
        }

        private record ParentAdapter(LootPoolBuilder builder) implements LootEntryBuilder.Parent<LootPoolBuilder>
        {
            @Override
            public LootPoolBuilder entry(LootEntry entry) {
                return this.builder().entry(entry);
            }
        }
    }

    public static final class LootEntryBuilder<T, U extends Parent<T>> {
        private final U parent;
        private final class_2960 type;
        private final ValidityFlags validityFlags;
        private final List<LootCondition> conditions;
        private final List<LootFunction> functions;
        private final List<LootEntry> children;
        private String name;
        private LootFlags flags;

        LootEntryBuilder(U parent, class_2960 type) {
            this.parent = parent;
            this.type = type;
            this.validityFlags = ValidityFlags.of(this.type);
            this.conditions = new ArrayList<LootCondition>();
            this.functions = new ArrayList<LootFunction>();
            this.children = new ArrayList<LootEntry>();
            this.name = null;
            this.flags = new LootFlags(null, null, null);
        }

        public LootEntryBuilder<T, U> name(String name) {
            if (!this.validityFlags.name()) {
                throw new IllegalStateException("Unable to set name with type " + this.type);
            }
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public LootEntryBuilder<T, U> conditionally(class_2960 type, JsonObject parameters) {
            this.conditions.add(new LootCondition(Objects.requireNonNull(type), Objects.requireNonNull(parameters)));
            return this;
        }

        public LootEntryBuilder<T, U> function(class_2960 type, JsonObject parameters) {
            this.functions.add(new LootFunction(Objects.requireNonNull(type), Objects.requireNonNull(parameters)));
            return this;
        }

        public LootEntryBuilder<LootEntryBuilder<T, U>, ParentAdapter<T, U>> child(class_2960 type) {
            if (!this.validityFlags.children()) {
                throw new IllegalStateException("Unable to set add children with type " + this.type);
            }
            return new LootEntryBuilder<LootEntryBuilder<T, U>, ParentAdapter<T, U>>(new ParentAdapter(this), type);
        }

        public LootEntryBuilder<T, U> expand(boolean expand) {
            if (!this.validityFlags.expand()) {
                throw new IllegalStateException("Unable to set expand for type " + this.type);
            }
            this.flags = new LootFlags(expand, this.flags.weight(), this.flags.quality());
            return this;
        }

        public LootEntryBuilder<T, U> expand() {
            return this.expand(true);
        }

        public LootEntryBuilder<T, U> weight(int weight) {
            this.flags = new LootFlags(this.flags.expand(), weight, this.flags.quality());
            return this;
        }

        public LootEntryBuilder<T, U> quality(int quality) {
            this.flags = new LootFlags(this.flags.expand(), this.flags.weight(), quality);
            return this;
        }

        public T finish() {
            return (T)this.parent.entry(new LootEntry(new ArrayList<LootCondition>(this.conditions), new ArrayList<LootFunction>(this.functions), this.type, this.name, new ArrayList<LootEntry>(this.children), this.flags));
        }

        LootEntryBuilder<T, U> entry(LootEntry entry) {
            this.children.add(entry);
            return this;
        }

        @FunctionalInterface
        static interface Parent<J> {
            public J entry(LootEntry var1);
        }

        private record ValidityFlags(boolean name, boolean children, boolean expand) {
            private static final Set<class_2960> VALID_FOR_NAME = ValidityFlags.s("item", "tag", "loot_table", "dynamic");
            private static final Set<class_2960> VALID_FOR_CHILDREN = ValidityFlags.s("group", "alternatives", "sequence");
            private static final Set<class_2960> VALID_FOR_EXPAND = ValidityFlags.s("tag");
            private static final Set<class_2960> VALID_TYPES = ValidityFlags.s(VALID_FOR_NAME, VALID_FOR_CHILDREN, "empty");

            static ValidityFlags of(class_2960 type) {
                if (!VALID_TYPES.contains(Objects.requireNonNull(type))) {
                    throw new IllegalArgumentException("Invalid type " + type);
                }
                return new ValidityFlags(VALID_FOR_NAME.contains(type), VALID_FOR_CHILDREN.contains(type), VALID_FOR_EXPAND.contains(type));
            }

            private static Set<class_2960> s(String ... elements) {
                return Arrays.stream(elements).map(class_2960::new).collect(Collectors.toUnmodifiableSet());
            }

            private static Set<class_2960> s(Set<class_2960> a, Set<class_2960> b, String ... c) {
                return Stream.concat(Stream.concat(a.stream(), b.stream()), Arrays.stream(c).map(class_2960::new)).collect(Collectors.toUnmodifiableSet());
            }
        }

        private record ParentAdapter<S, R extends Parent<S>>(LootEntryBuilder<S, R> parent) implements Parent<LootEntryBuilder<S, R>>
        {
            @Override
            public LootEntryBuilder<S, R> entry(LootEntry entry) {
                return this.parent().entry(entry);
            }
        }
    }

    private record LootPool(List<LootCondition> conditions, List<LootFunction> functions, LootNumber rolls, LootNumber bonus, List<LootEntry> entries) implements ConditionFunctionSerializable
    {
        JsonElement serialize() {
            JsonObject object = new JsonObject();
            this.serializeInto(object);
            object.add("rolls", this.rolls().serialize());
            object.add("bonus_rolls", this.bonus().serialize());
            if (!this.entries().isEmpty()) {
                JsonArray children = new JsonArray();
                this.entries().stream().map(LootEntry::serialize).forEach(arg_0 -> ((JsonArray)children).add(arg_0));
                object.add("entries", (JsonElement)children);
            }
            return object;
        }
    }

    private record LootEntry(List<LootCondition> conditions, List<LootFunction> functions, class_2960 type, String name, List<LootEntry> children, LootFlags flags) implements ConditionFunctionSerializable
    {
        JsonElement serialize() {
            JsonObject object = new JsonObject();
            this.serializeInto(object);
            object.addProperty("type", this.type().toString());
            if (this.name != null) {
                object.addProperty("name", this.name());
            }
            if (!this.children().isEmpty()) {
                JsonArray children = new JsonArray();
                this.children().stream().map(LootEntry::serialize).forEach(arg_0 -> ((JsonArray)children).add(arg_0));
                object.add("children", (JsonElement)children);
            }
            this.flags().serializeInto(object);
            return object;
        }
    }

    private record LootFlags(Boolean expand, Integer weight, Integer quality) {
        void serializeInto(JsonObject object) {
            if (this.expand() != null) {
                object.addProperty("expand", this.expand());
            }
            if (this.weight() != null) {
                object.addProperty("weight", (Number)this.weight());
            }
            if (this.quality() != null) {
                object.addProperty("quality", (Number)this.quality());
            }
        }
    }

    private static interface ConditionFunctionSerializable {
        public List<LootCondition> conditions();

        public List<LootFunction> functions();

        default public void serializeInto(JsonObject object) {
            if (!this.conditions().isEmpty()) {
                JsonArray conditions = new JsonArray();
                this.conditions().stream().map(TypeParametersSerializable::serialize).forEach(arg_0 -> ((JsonArray)conditions).add(arg_0));
                object.add("conditions", (JsonElement)conditions);
            }
            if (!this.functions().isEmpty()) {
                JsonArray functions = new JsonArray();
                this.functions().stream().map(TypeParametersSerializable::serialize).forEach(arg_0 -> ((JsonArray)functions).add(arg_0));
                object.add("functions", (JsonElement)functions);
            }
        }
    }

    private record LootNumber(Integer i, Float f, class_2960 type, JsonObject parameters) implements TypeParametersSerializable
    {
        @Override
        public JsonElement serialize() {
            if (this.i() != null || this.f() != null) {
                return new JsonPrimitive((Number)Float.valueOf(this.i() == null ? this.f().floatValue() : (float)this.i().intValue()));
            }
            return TypeParametersSerializable.super.serialize();
        }
    }

    private record LootCondition(class_2960 type, JsonObject parameters) implements TypeParametersSerializable
    {
    }

    private static interface TypeParametersSerializable {
        public class_2960 type();

        public JsonObject parameters();

        default public String typeId() {
            return this instanceof LootFunction ? "function" : (this instanceof LootCondition ? "condition" : "type");
        }

        default public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty(this.typeId(), this.type().toString());
            this.parameters().entrySet().forEach(entry -> object.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            return object;
        }
    }
}

