/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;

public final class Language {
    public static final ResourceSerializer<Language> SERIALIZER = Language::serialize;
    private final Map<String, String> keys = new HashMap<String, String>();

    private Language() {
    }

    public static Language of() {
        return new Language();
    }

    public Language add(String key, String text) {
        Objects.requireNonNull(text);
        if (this.keys.containsKey(Objects.requireNonNull(key))) {
            throw new IllegalArgumentException("Key " + key + " already exists");
        }
        this.keys.put(key, text);
        return this;
    }

    public Language block(class_2960 name, String text) {
        return this.add("block.%s.%s".formatted(Objects.requireNonNull(name).method_12836(), name.method_12832()), Objects.requireNonNull(text));
    }

    public Language item(class_2960 name, String text) {
        return this.add("item.%s.%s".formatted(Objects.requireNonNull(name).method_12836(), name.method_12832()), Objects.requireNonNull(text));
    }

    public Language tab(String name, String text) {
        return this.add("itemGroup.%s".formatted(Objects.requireNonNull(name)), Objects.requireNonNull(text));
    }

    private byte[] serialize() {
        JsonObject object = new JsonObject();
        this.keys.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }
}

