/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1161;
import net.minecraft.class_1162;
import net.minecraft.class_2960;

public final class BlockModel {
    public static final ResourceSerializer<BlockModel> SERIALIZER = BlockModel::serialize;
    private final class_2960 parent;
    private final Map<DisplayPosition, DisplayData> positions;
    private final Map<String, class_2960> textures;
    private final List<Element> elements;
    private boolean ambientOcclusion;

    private BlockModel(class_2960 parent) {
        this.parent = parent;
        this.positions = new HashMap<DisplayPosition, DisplayData>();
        this.textures = new HashMap<String, class_2960>();
        this.elements = new ArrayList<Element>();
        this.ambientOcclusion = true;
    }

    public static BlockModel of(class_2960 parent) {
        return new BlockModel(parent);
    }

    public static BlockModel ofGenerated() {
        return new BlockModel(new class_2960("builtin/generated"));
    }

    public BlockModel ambientOcclusion(boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
        return this;
    }

    public BlockModel noAmbientOcclusion() {
        return this.ambientOcclusion(false);
    }

    public BlockModel display(DisplayPosition position, class_1161 rotation, class_1161 translation, class_1161 scale) {
        Objects.requireNonNull(position);
        if (rotation == null && translation == null && scale == null) {
            throw new IllegalArgumentException("At least one between rotation, translation, and scale must be set");
        }
        if (this.positions.containsKey((Object)position)) {
            throw new IllegalArgumentException("Position " + position + " is already set");
        }
        this.positions.put(position, new DisplayData(this.clone(rotation), this.clone(translation), this.clone(scale)));
        return this;
    }

    public ElementBuilder element(class_1161 from, class_1161 to) {
        return this.element(from, to, true);
    }

    public ElementBuilder element(class_1161 from, class_1161 to, boolean shade) {
        return new ElementBuilder(this, Objects.requireNonNull(from), Objects.requireNonNull(to), shade);
    }

    public BlockModel texture(String name, class_2960 path) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(path);
        if (this.textures.containsKey(name)) {
            throw new IllegalArgumentException("Texture was already specified for " + name);
        }
        this.textures.put(name, path);
        return this;
    }

    public BlockModel particle(class_2960 path) {
        return this.texture("particle", path);
    }

    public BlockModel layer(int id, class_2960 path) {
        if (id < 0) {
            throw new IllegalStateException("Invalid id " + id + " for layer");
        }
        return this.texture("layer" + id, path);
    }

    private BlockModel element(Element element) {
        this.elements.add(element);
        return this;
    }

    private class_1161 clone(class_1161 original) {
        return original != null ? new class_1161(original.field_5661, original.field_5660, original.field_5659) : null;
    }

    private byte[] serialize() {
        JsonObject object = new JsonObject();
        if (this.parent != null) {
            object.addProperty("parent", this.parent.toString());
        }
        object.addProperty("ambientocclusion", Boolean.valueOf(this.ambientOcclusion));
        if (!this.positions.isEmpty()) {
            JsonObject positions = new JsonObject();
            this.positions.forEach((position, data) -> {
                JsonObject jsonData = new JsonObject();
                this.serializeVector(jsonData, "rotation", data.rotation());
                this.serializeVector(jsonData, "translation", data.translation());
                this.serializeVector(jsonData, "scale", data.scale());
                positions.add(position.toString(), (JsonElement)jsonData);
            });
            object.add("display", (JsonElement)positions);
        }
        if (!this.textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            this.textures.forEach((name, id) -> textures.addProperty(name, id.toString()));
            object.add("textures", (JsonElement)textures);
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.forEach(element -> elements.add(element.serialize(this::serializeVector, this::serializeVector)));
            object.add("elements", (JsonElement)elements);
        }
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }

    private void serializeVector(JsonObject object, String name, class_1161 vector) {
        if (vector == null) {
            return;
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)new JsonPrimitive((Number)vector.field_5661));
        array.add((JsonElement)new JsonPrimitive((Number)vector.field_5660));
        array.add((JsonElement)new JsonPrimitive((Number)vector.field_5659));
        object.add(name, (JsonElement)array);
    }

    private void serializeVector(JsonObject object, String name, class_1162 vector) {
        if (vector == null) {
            return;
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.method_4953())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.method_4956())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.method_4957())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.method_23853())));
        object.add(name, (JsonElement)array);
    }

    public static enum DisplayPosition {
        THIRD_RIGHT("thirdperson_righthand"),
        THIRD_LEFT("thirdperson_lefthand"),
        FIRST_RIGHT("firstperson_righthand"),
        FIRST_LEFT("firstperson_lefthand"),
        GUI("gui"),
        HEAD("head"),
        GROUND("ground"),
        FIXED("fixed");

        private final String id;

        private DisplayPosition(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    private record DisplayData(class_1161 rotation, class_1161 translation, class_1161 scale) {
    }

    public static final class ElementBuilder {
        private final BlockModel parent;
        private final class_1161 from;
        private final class_1161 to;
        private final boolean shade;
        private final Map<FacePosition, Element.Face> faces;
        private Element.Rotation rotation;

        ElementBuilder(BlockModel parent, class_1161 from, class_1161 to, boolean shade) {
            this.parent = parent;
            this.from = from;
            this.to = to;
            this.shade = shade;
            this.faces = new HashMap<FacePosition, Element.Face>();
            this.rotation = null;
        }

        public ElementBuilder rotate(class_1161 origin, RotationAxis axis, float angle) {
            return this.rotate(origin, axis, angle, false);
        }

        public ElementBuilder rotate(class_1161 origin, RotationAxis axis, float angle, boolean rescale) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(axis);
            if (angle != -45.0f && (double)angle != -22.5 && angle != 0.0f && (double)angle != 22.5 && angle != 45.0f) {
                throw new IllegalArgumentException("Invalid angle for rotation " + angle);
            }
            this.rotation = new Element.Rotation(origin, axis, angle, rescale);
            return this;
        }

        public ElementBuilder face(FacePosition position, String texture) {
            return this.face(position, null, texture);
        }

        public ElementBuilder face(FacePosition position, class_1162 uvs, String texture) {
            return this.face(position, uvs, texture, null);
        }

        public ElementBuilder face(FacePosition position, class_1162 uvs, String texture, FacePosition cull) {
            return this.face(position, uvs, texture, cull, 0);
        }

        public ElementBuilder face(FacePosition position, class_1162 uvs, String texture, int rotation) {
            return this.face(position, uvs, texture, null, rotation);
        }

        public ElementBuilder face(FacePosition position, class_1162 uvs, String texture, FacePosition cull, int rotation) {
            return this.face(position, uvs, texture, cull, rotation, null);
        }

        public ElementBuilder face(FacePosition position, class_1162 uvs, String texture, FacePosition cull, int rotation, Integer tintIndex) {
            Objects.requireNonNull(position);
            Objects.requireNonNull(texture);
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid angle for rotation " + rotation);
            }
            if (this.faces.containsKey((Object)position)) {
                throw new IllegalArgumentException("Face for position " + position + " was already specified");
            }
            this.faces.put(position, new Element.Face(uvs, texture, cull, rotation, tintIndex));
            return this;
        }

        public BlockModel finish() {
            return this.parent.element(new Element(this.from, this.to, this.rotation, this.shade, this.faces));
        }
    }

    @FunctionalInterface
    private static interface VectorSerializer<T> {
        public void serializeVector(JsonObject var1, String var2, T var3);
    }

    private record Element(class_1161 from, class_1161 to, Rotation rotation, boolean shade, Map<FacePosition, Face> faces) {
        JsonElement serialize(VectorSerializer<class_1161> threeSerializer, VectorSerializer<class_1162> fourSerializer) {
            JsonObject object = new JsonObject();
            threeSerializer.serializeVector(object, "from", this.from());
            threeSerializer.serializeVector(object, "to", this.to());
            if (this.rotation() != null) {
                JsonObject rotation = new JsonObject();
                threeSerializer.serializeVector(rotation, "origin", this.rotation().origin());
                rotation.addProperty("axis", this.rotation().axis().toString());
                rotation.addProperty("angle", (Number)Float.valueOf(this.rotation().angle()));
                rotation.addProperty("rescale", Boolean.valueOf(this.rotation().scale()));
                object.add("rotation", (JsonElement)rotation);
            }
            object.addProperty("shade", Boolean.valueOf(this.shade()));
            if (!this.faces().isEmpty()) {
                JsonObject faces = new JsonObject();
                this.faces().forEach((position, face) -> faces.add(position.toString(), face.serialize(fourSerializer)));
                object.add("faces", (JsonElement)faces);
            }
            return object;
        }

        record Rotation(class_1161 origin, RotationAxis axis, float angle, boolean scale) {
        }

        record Face(class_1162 uv, String texture, FacePosition cull, int rotation, Integer tintIndex) {
            JsonElement serialize(VectorSerializer<class_1162> fourSerializer) {
                JsonObject object = new JsonObject();
                fourSerializer.serializeVector(object, "uv", this.uv);
                object.addProperty("texture", "#%s".formatted(this.texture()));
                if (this.cull() != null) {
                    object.addProperty("cullface", this.cull().toString());
                }
                object.addProperty("rotation", (Number)this.rotation());
                if (this.tintIndex() != null) {
                    object.addProperty("tintindex", (Number)this.tintIndex());
                }
                return object;
            }
        }
    }

    public static enum FacePosition {
        DOWN("down"),
        UP("up"),
        NORTH("north"),
        SOUTH("south"),
        WEST("west"),
        EAST("east");

        private final String id;

        private FacePosition(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum RotationAxis {
        X("x"),
        Y("y"),
        Z("z");

        private final String id;

        private RotationAxis(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

