/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2498;
import net.minecraft.class_2960;

public final class SoundTypeRegistry
implements GameRegistry<class_2498> {
    private final BiMap<class_2960, class_2498> soundTypes = HashBiMap.create();
    private final BiMap<class_2498, class_2960> inverse = this.soundTypes.inverse();
    private final Consumer<BiMap<class_2960, class_2498>> vanillaProvider = map -> map.putAll((Map)vanillaComputer.get());
    private final Map<class_2960, Supplier<class_2498>> commands = new HashMap<class_2960, Supplier<class_2498>>();

    private SoundTypeRegistry(Supplier<Map<class_2960, class_2498>> vanillaComputer) {
    }

    public static SoundTypeRegistry of() {
        return new SoundTypeRegistry(SoundTypeRegistry::gatherVanilla);
    }

    private static Map<class_2960, class_2498> gatherVanilla() {
        HashMap<class_2960, class_2498> map = new HashMap<class_2960, class_2498>();
        SoundTypeRegistry.entry(map, "wood", class_2498.field_11547);
        SoundTypeRegistry.entry(map, "gravel", class_2498.field_11529);
        SoundTypeRegistry.entry(map, "grass", class_2498.field_11535);
        SoundTypeRegistry.entry(map, "lily_pad", class_2498.field_25183);
        SoundTypeRegistry.entry(map, "stone", class_2498.field_11544);
        SoundTypeRegistry.entry(map, "metal", class_2498.field_11533);
        SoundTypeRegistry.entry(map, "glass", class_2498.field_11537);
        SoundTypeRegistry.entry(map, "wool", class_2498.field_11543);
        SoundTypeRegistry.entry(map, "sand", class_2498.field_11526);
        SoundTypeRegistry.entry(map, "snow", class_2498.field_11548);
        SoundTypeRegistry.entry(map, "powder_snow", class_2498.field_27884);
        SoundTypeRegistry.entry(map, "ladder", class_2498.field_11532);
        SoundTypeRegistry.entry(map, "anvil", class_2498.field_11531);
        SoundTypeRegistry.entry(map, "slime_block", class_2498.field_11545);
        SoundTypeRegistry.entry(map, "honey_block", class_2498.field_21214);
        SoundTypeRegistry.entry(map, "wet_grass", class_2498.field_11534);
        SoundTypeRegistry.entry(map, "coral_block", class_2498.field_11528);
        SoundTypeRegistry.entry(map, "bamboo", class_2498.field_11542);
        SoundTypeRegistry.entry(map, "bamboo_sapling", class_2498.field_11538);
        SoundTypeRegistry.entry(map, "scaffolding", class_2498.field_16498);
        SoundTypeRegistry.entry(map, "sweet_berry_bush", class_2498.field_17579);
        SoundTypeRegistry.entry(map, "crop", class_2498.field_17580);
        SoundTypeRegistry.entry(map, "hard_crop", class_2498.field_18852);
        SoundTypeRegistry.entry(map, "vine", class_2498.field_23083);
        SoundTypeRegistry.entry(map, "nether_wart", class_2498.field_17581);
        SoundTypeRegistry.entry(map, "lantern", class_2498.field_17734);
        SoundTypeRegistry.entry(map, "stem", class_2498.field_22152);
        SoundTypeRegistry.entry(map, "nylium", class_2498.field_22153);
        SoundTypeRegistry.entry(map, "fungus", class_2498.field_22154);
        SoundTypeRegistry.entry(map, "roots", class_2498.field_22138);
        SoundTypeRegistry.entry(map, "shroomlight", class_2498.field_22139);
        SoundTypeRegistry.entry(map, "weeping_vines", class_2498.field_22140);
        SoundTypeRegistry.entry(map, "twisting_vines", class_2498.field_23082);
        SoundTypeRegistry.entry(map, "soul_sand", class_2498.field_22141);
        SoundTypeRegistry.entry(map, "soul_soil", class_2498.field_22142);
        SoundTypeRegistry.entry(map, "basalt", class_2498.field_22143);
        SoundTypeRegistry.entry(map, "wart_block", class_2498.field_22144);
        SoundTypeRegistry.entry(map, "netherrack", class_2498.field_22145);
        SoundTypeRegistry.entry(map, "nether_bricks", class_2498.field_22146);
        SoundTypeRegistry.entry(map, "nether_sprouts", class_2498.field_22147);
        SoundTypeRegistry.entry(map, "nether_ore", class_2498.field_22148);
        SoundTypeRegistry.entry(map, "bone_block", class_2498.field_22149);
        SoundTypeRegistry.entry(map, "netherite_block", class_2498.field_22150);
        SoundTypeRegistry.entry(map, "ancient_debris", class_2498.field_22151);
        SoundTypeRegistry.entry(map, "lodestone", class_2498.field_23265);
        SoundTypeRegistry.entry(map, "chain", class_2498.field_24119);
        SoundTypeRegistry.entry(map, "nether_gold_ore", class_2498.field_24120);
        SoundTypeRegistry.entry(map, "gilded_blackstone", class_2498.field_24121);
        SoundTypeRegistry.entry(map, "candle", class_2498.field_27196);
        SoundTypeRegistry.entry(map, "amethyst", class_2498.field_27197);
        SoundTypeRegistry.entry(map, "amethyst_cluster", class_2498.field_27198);
        SoundTypeRegistry.entry(map, "small_amethyst_bud", class_2498.field_27199);
        SoundTypeRegistry.entry(map, "medium_amethyst_bud", class_2498.field_27200);
        SoundTypeRegistry.entry(map, "large_amethyst_bud", class_2498.field_27201);
        SoundTypeRegistry.entry(map, "tuff", class_2498.field_27202);
        SoundTypeRegistry.entry(map, "calcite", class_2498.field_27203);
        SoundTypeRegistry.entry(map, "dripstone_block", class_2498.field_28060);
        SoundTypeRegistry.entry(map, "pointed_dripstone", class_2498.field_28061);
        SoundTypeRegistry.entry(map, "copper", class_2498.field_27204);
        SoundTypeRegistry.entry(map, "cave_vines", class_2498.field_28692);
        SoundTypeRegistry.entry(map, "spore_blossom", class_2498.field_28693);
        SoundTypeRegistry.entry(map, "azalea", class_2498.field_28694);
        SoundTypeRegistry.entry(map, "flowering_azalea", class_2498.field_28695);
        SoundTypeRegistry.entry(map, "moss_carpet", class_2498.field_28696);
        SoundTypeRegistry.entry(map, "moss", class_2498.field_28697);
        SoundTypeRegistry.entry(map, "big_dripleaf", class_2498.field_28698);
        SoundTypeRegistry.entry(map, "small_dripleaf", class_2498.field_28699);
        SoundTypeRegistry.entry(map, "rooted_dirt", class_2498.field_28700);
        SoundTypeRegistry.entry(map, "hanging_roots", class_2498.field_28701);
        SoundTypeRegistry.entry(map, "azalea_leaves", class_2498.field_28702);
        SoundTypeRegistry.entry(map, "sculk_sensor", class_2498.field_28116);
        SoundTypeRegistry.entry(map, "glow_lichen", class_2498.field_28427);
        SoundTypeRegistry.entry(map, "deepslate", class_2498.field_29033);
        SoundTypeRegistry.entry(map, "deepslate_bricks", class_2498.field_29034);
        SoundTypeRegistry.entry(map, "deepslate_tiles", class_2498.field_29035);
        SoundTypeRegistry.entry(map, "polished_deepslate", class_2498.field_29036);
        return map;
    }

    private static void entry(Map<class_2960, class_2498> map, String name, class_2498 type) {
        map.put(new class_2960(name.toLowerCase(Locale.ENGLISH)), type);
    }

    @Override
    public ObjectType<class_2498> type() {
        return VanillaObjectTypes.SOUND_TYPE;
    }

    @Override
    public class_2498 get(class_2960 name) {
        this.populateMap();
        if (this.commands.containsKey(name)) {
            return this.register(name, this.commands.get(name));
        }
        return (class_2498)this.soundTypes.get((Object)name);
    }

    @Override
    public class_2960 nameOf(class_2498 type) {
        this.populateMap();
        return (class_2960)this.inverse.computeIfAbsent((Object)type, it -> {
            throw new IllegalArgumentException("No such sound type " + it + " known: it is probably not registered");
        });
    }

    @Override
    public Collection<class_2498> all() {
        this.populateMap();
        return this.soundTypes.values();
    }

    @Override
    public void enqueueRegistration(class_2960 name, Supplier<class_2498> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.commands.containsKey(name)) {
            throw new IllegalArgumentException("A sound type with name '" + name + "' was already enqueued for registration");
        }
        this.commands.put(name, objectCreator);
    }

    private void populateMap() {
        if (this.soundTypes.isEmpty()) {
            this.vanillaProvider.accept(this.soundTypes);
        }
    }

    public class_2498 register(class_2960 name, Supplier<class_2498> creator) {
        Objects.requireNonNull(creator);
        if (this.soundTypes.containsKey((Object)Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("A sound type with name '" + name + "' is already known");
        }
        class_2498 material = Objects.requireNonNull(creator.get());
        this.soundTypes.put((Object)name, (Object)material);
        this.commands.remove(name);
        return material;
    }
}

