/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3614;

public final class MaterialRegistry
implements GameRegistry<class_3614> {
    private final BiMap<class_2960, class_3614> materials = HashBiMap.create();
    private final BiMap<class_3614, class_2960> inverse = this.materials.inverse();
    private final Consumer<BiMap<class_2960, class_3614>> vanillaGatherer = map -> map.putAll((Map)vanillaMaterialsGetter.get());
    private final Map<class_2960, Supplier<class_3614>> commands = new HashMap<class_2960, Supplier<class_3614>>();

    private MaterialRegistry(Supplier<Map<class_2960, class_3614>> vanillaMaterialsGetter) {
    }

    public static MaterialRegistry of() {
        return new MaterialRegistry(MaterialRegistry::computeVanillaMaterials);
    }

    private static Map<class_2960, class_3614> computeVanillaMaterials() {
        HashMap<class_2960, class_3614> map = new HashMap<class_2960, class_3614>();
        MaterialRegistry.entry(map, "air", class_3614.field_15959);
        MaterialRegistry.entry(map, "structural_air", class_3614.field_15927);
        MaterialRegistry.entry(map, "portal", class_3614.field_15919);
        MaterialRegistry.entry(map, "cloth_decoration", class_3614.field_15957);
        MaterialRegistry.entry(map, "plant", class_3614.field_15935);
        MaterialRegistry.entry(map, "water_plant", class_3614.field_15947);
        MaterialRegistry.entry(map, "replaceable_plant", class_3614.field_15956);
        MaterialRegistry.entry(map, "replaceable_fireproof_plant", class_3614.field_26708);
        MaterialRegistry.entry(map, "replaceable_water_plant", class_3614.field_15926);
        MaterialRegistry.entry(map, "water", class_3614.field_15920);
        MaterialRegistry.entry(map, "bubble_column", class_3614.field_15915);
        MaterialRegistry.entry(map, "lava", class_3614.field_15922);
        MaterialRegistry.entry(map, "top_snow", class_3614.field_15948);
        MaterialRegistry.entry(map, "fire", class_3614.field_15943);
        MaterialRegistry.entry(map, "decoration", class_3614.field_15924);
        MaterialRegistry.entry(map, "web", class_3614.field_15913);
        MaterialRegistry.entry(map, "sculk", class_3614.field_28242);
        MaterialRegistry.entry(map, "buildable_glass", class_3614.field_15918);
        MaterialRegistry.entry(map, "clay", class_3614.field_15936);
        MaterialRegistry.entry(map, "dirt", class_3614.field_15941);
        MaterialRegistry.entry(map, "grass", class_3614.field_15945);
        MaterialRegistry.entry(map, "ice_solid", class_3614.field_15928);
        MaterialRegistry.entry(map, "sand", class_3614.field_15916);
        MaterialRegistry.entry(map, "sponge", class_3614.field_15917);
        MaterialRegistry.entry(map, "shulker_shell", class_3614.field_17008);
        MaterialRegistry.entry(map, "wood", class_3614.field_15932);
        MaterialRegistry.entry(map, "nether_wood", class_3614.field_22223);
        MaterialRegistry.entry(map, "bamboo_sapling", class_3614.field_15938);
        MaterialRegistry.entry(map, "bamboo", class_3614.field_15946);
        MaterialRegistry.entry(map, "wool", class_3614.field_15931);
        MaterialRegistry.entry(map, "explosive", class_3614.field_15955);
        MaterialRegistry.entry(map, "leaves", class_3614.field_15923);
        MaterialRegistry.entry(map, "glass", class_3614.field_15942);
        MaterialRegistry.entry(map, "ice", class_3614.field_15958);
        MaterialRegistry.entry(map, "cactus", class_3614.field_15925);
        MaterialRegistry.entry(map, "stone", class_3614.field_15914);
        MaterialRegistry.entry(map, "metal", class_3614.field_15953);
        MaterialRegistry.entry(map, "snow", class_3614.field_15934);
        MaterialRegistry.entry(map, "heavy_metal", class_3614.field_15949);
        MaterialRegistry.entry(map, "barrier", class_3614.field_15952);
        MaterialRegistry.entry(map, "piston", class_3614.field_15933);
        MaterialRegistry.entry(map, "moss", class_3614.field_15921);
        MaterialRegistry.entry(map, "vegetable", class_3614.field_15954);
        MaterialRegistry.entry(map, "egg", class_3614.field_15930);
        MaterialRegistry.entry(map, "cake", class_3614.field_15937);
        MaterialRegistry.entry(map, "amethyst", class_3614.field_27340);
        MaterialRegistry.entry(map, "powder_snow", class_3614.field_27890);
        return map;
    }

    private static void entry(Map<class_2960, class_3614> map, String name, class_3614 material) {
        map.put(new class_2960(name.toLowerCase(Locale.ENGLISH)), material);
    }

    @Override
    public ObjectType<class_3614> type() {
        return VanillaObjectTypes.MATERIAL;
    }

    @Override
    public class_3614 get(class_2960 name) {
        this.populateMap();
        if (this.commands.containsKey(name)) {
            return this.register(name, this.commands.get(name));
        }
        return (class_3614)this.materials.get((Object)name);
    }

    @Override
    public class_2960 nameOf(class_3614 material) {
        this.populateMap();
        return (class_2960)this.inverse.computeIfAbsent((Object)material, it -> {
            throw new IllegalArgumentException("No such material " + it + " known: it is probably not registered");
        });
    }

    @Override
    public Collection<class_3614> all() {
        this.populateMap();
        return this.materials.values();
    }

    @Override
    public void enqueueRegistration(class_2960 name, Supplier<class_3614> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.commands.containsKey(name)) {
            throw new IllegalArgumentException("A material with name '" + name + "' was already enqueued for registration");
        }
        this.commands.put(name, objectCreator);
    }

    public class_3614 register(class_2960 name, Supplier<class_3614> creator) {
        Objects.requireNonNull(creator);
        if (this.materials.containsKey((Object)Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("A material with name " + name + " is already known");
        }
        class_3614 material = Objects.requireNonNull(creator.get());
        this.materials.put((Object)name, (Object)material);
        this.commands.remove(name);
        return material;
    }

    private void populateMap() {
        if (this.materials.isEmpty()) {
            this.vanillaGatherer.accept(this.materials);
        }
    }
}

