/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3620;

public final class MaterialColorRegistry
implements GameRegistry<class_3620> {
    private final Object2IntMap<String> colors;
    private final Int2ObjectMap<String> inverseLookup;

    private MaterialColorRegistry(Supplier<Object2IntMap<String>> gatherer, Function<Object2IntMap<String>, Int2ObjectMap<String>> inverter) {
        this.colors = Objects.requireNonNull(gatherer).get();
        this.inverseLookup = Objects.requireNonNull(inverter).apply(this.colors);
    }

    public static MaterialColorRegistry of() {
        return new MaterialColorRegistry(MaterialColorRegistry::gather, MaterialColorRegistry::invert);
    }

    private static Object2IntMap<String> gather() {
        Object2IntArrayMap map = new Object2IntArrayMap();
        map.defaultReturnValue(0);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "none", 0, 0);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "grass", 1, 8368696);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "sand", 2, 16247203);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "wool", 3, 0xC7C7C7);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "fire", 4, 0xFF0000);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "ice", 5, 0xA0A0FF);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "metal", 6, 0xA7A7A7);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "plant", 7, 31744);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "snow", 8, 0xFFFFFF);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "clay", 9, 10791096);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "dirt", 10, 9923917);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "stone", 11, 0x707070);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "water", 12, 0x4040FF);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "wood", 13, 9402184);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "quartz", 14, 0xFFFCF5);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_orange", 15, 14188339);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_magenta", 16, 11685080);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_light_blue", 17, 6724056);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_yellow", 18, 0xE5E533);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_light_green", 19, 8375321);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_pink", 20, 15892389);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_gray", 21, 0x4C4C4C);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_light_gray", 22, 0x999999);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_cyan", 23, 5013401);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_purple", 24, 8339378);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_blue", 25, 3361970);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_brown", 26, 6704179);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_green", 27, 6717235);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_red", 28, 0x993333);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "color_black", 29, 0x191919);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "gold", 30, 16445005);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "diamond", 31, 6085589);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "lapis", 32, 4882687);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "emerald", 33, 55610);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "podzol", 34, 8476209);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "nether", 35, 0x700200);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_white", 36, 13742497);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_orange", 37, 10441252);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_magenta", 38, 9787244);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_light_blue", 39, 7367818);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_yellow", 40, 12223780);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_light_green", 41, 6780213);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_pink", 42, 10505550);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_gray", 43, 0x392923);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_light_gray", 44, 8874850);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_cyan", 45, 0x575C5C);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_purple", 46, 8014168);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_blue", 47, 4996700);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_brown", 48, 4993571);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_green", 49, 5001770);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_red", 50, 9321518);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "terracotta_black", 51, 2430480);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "crimson_nylium", 52, 12398641);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "crimson_stem", 53, 9715553);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "crimson_hyphae", 54, 6035741);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "warped_nylium", 55, 1474182);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "warped_stem", 56, 3837580);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "warped_hyphae", 57, 5647422);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "warped_wart_block", 58, 1356933);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "deepslate", 59, 0x646464);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "raw_iron", 60, 14200723);
        MaterialColorRegistry.entry((Object2IntMap<String>)map, "glow_lichen", 61, 8365974);
        return map;
    }

    private static void entry(Object2IntMap<String> map, String name, int id, int color) {
        map.put((Object)name.toLowerCase(Locale.ENGLISH), id << 24 | color & 0xFFFFFF);
    }

    private static Int2ObjectMap<String> invert(Object2IntMap<String> map) {
        Int2ObjectArrayMap inverse = new Int2ObjectArrayMap();
        map.object2IntEntrySet().forEach(arg_0 -> MaterialColorRegistry.lambda$invert$0((Int2ObjectMap)inverse, arg_0));
        return inverse;
    }

    private static int id(int packed) {
        return packed >>> 24 & 0xFF;
    }

    private static int color(int packed) {
        return packed & 0xFFFFFF;
    }

    @Override
    public ObjectType<class_3620> type() {
        return VanillaObjectTypes.MATERIAL_COLOR;
    }

    @Override
    public class_3620 get(class_2960 name) {
        return class_3620.method_38479((int)MaterialColorRegistry.id(this.colors.getInt((Object)Objects.requireNonNull(name).method_12832())));
    }

    @Override
    public class_2960 nameOf(class_3620 object) {
        return new class_2960((String)this.inverseLookup.get(Objects.requireNonNull(object).field_16021));
    }

    @Override
    public Collection<class_3620> all() {
        return this.colors.values().intStream().map(MaterialColorRegistry::id).mapToObj(class_3620::method_38479).toList();
    }

    @Override
    public void enqueueRegistration(class_2960 name, Supplier<class_3620> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        throw new IllegalStateException("Unable to register new material colors");
    }

    private static /* synthetic */ void lambda$invert$0(Int2ObjectMap inverse, Object2IntMap.Entry it) {
        inverse.put(MaterialColorRegistry.id(it.getIntValue()), (Object)((String)it.getKey()));
    }
}

