/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.ContentTweakerVanillaApi;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_2960;

public final class CreativeTabRegistry
implements GameRegistry<class_1761> {
    private final Map<class_2960, class_1761> fastLookup = new HashMap<class_2960, class_1761>();
    private final Map<String, Supplier<class_1761>> creators = new HashMap<String, Supplier<class_1761>>();

    private CreativeTabRegistry() {
    }

    public static CreativeTabRegistry of() {
        return new CreativeTabRegistry();
    }

    public static class_2960 fromId(String name) {
        return new class_2960(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, Objects.requireNonNull(name)));
    }

    public static String toId(class_2960 name) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, Objects.requireNonNull(name).method_12832());
    }

    @Override
    public ObjectType<class_1761> type() {
        return VanillaObjectTypes.CREATIVE_TAB;
    }

    @Override
    public class_1761 get(class_2960 name) {
        if (this.fastLookup.containsKey(name)) {
            return this.fastLookup.get(name);
        }
        String id = CreativeTabRegistry.toId(name);
        if (this.creators.containsKey(id)) {
            this.register(this.creators.get(id));
            this.creators.remove(id);
        }
        class_1761 tab = Arrays.stream(class_1761.field_7921).filter(it -> id.equals(ContentTweakerVanillaApi.get().creativeTabId((class_1761)it))).findFirst().orElse(null);
        this.fastLookup.put(name, tab);
        return tab;
    }

    @Override
    public class_2960 nameOf(class_1761 object) {
        return CreativeTabRegistry.fromId(ContentTweakerVanillaApi.get().creativeTabId(Objects.requireNonNull(object)));
    }

    @Override
    public Collection<class_1761> all() {
        return Arrays.asList(class_1761.field_7921);
    }

    @Override
    public void enqueueRegistration(class_2960 name, Supplier<class_1761> objectCreator) {
        String id = CreativeTabRegistry.toId(name);
        if (this.creators.containsKey(id)) {
            throw new IllegalStateException("Already registered a creative tab for id '" + id + "'");
        }
        this.creators.put(id, objectCreator);
    }

    private void register(Supplier<class_1761> tab) {
        this.expandByOne();
        tab.get();
    }

    private void expandByOne() {
        class_1761[] tabs = class_1761.field_7921;
        int length = tabs.length;
        class_1761[] newTabs = new class_1761[length + 1];
        System.arraycopy(tabs, 0, newTabs, 0, length);
        newTabs[length] = null;
        ContentTweakerVanillaApi.get().creativeTabs(newTabs);
    }
}

