/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.fabric.service;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.core.service.PlatformService;
import com.blamejared.contenttweaker.fabric.registry.FabricGameRegistry;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public final class FabricPlatformService
implements PlatformService {
    @Override
    public Path gameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path locateResource(String ... components) {
        Objects.requireNonNull(components);
        if (components.length < 1) {
            throw new IllegalArgumentException("At least one component required");
        }
        List<Path> possiblePaths = ((ModContainer)FabricLoader.getInstance().getModContainer("contenttweaker").orElseThrow(IllegalStateException::new)).getRootPaths().stream().map(it -> it.resolve(String.join((CharSequence)"/", components))).toList();
        return possiblePaths.size() == 1 ? possiblePaths.get(0) : possiblePaths.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElse(possiblePaths.get(0));
    }

    @Override
    public <T> GameRegistry<T> findRegistryFromKey(ObjectType<T> type, class_5321<? extends class_2378<T>> key) {
        return FabricGameRegistry.of((class_2378)GenericUtil.uncheck((Object)Objects.requireNonNull((class_2378)class_2378.field_11144.method_10223(Objects.requireNonNull(key).method_29177()))), Objects.requireNonNull(type));
    }
}

