/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.fabric.registry;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.fabric.registry.FabricGameRegistry;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import net.minecraft.class_2378;

public final class FabricRegistrationManager {
    private FabricRegistrationManager() {
    }

    public static void registerAll(class_2378<? extends class_2378<?>> registry) {
        registry.iterator().forEachRemaining(FabricRegistrationManager::registerAndFreeze);
        ContentTweakerCore.LOGGER.info("Registries frozen");
    }

    private static <T> void registerAndFreeze(class_2378<T> registry) {
        FabricRegistrationManager.registerFor(registry);
        registry.method_40276();
    }

    private static <T> void registerFor(class_2378<T> registry) {
        ObjectType type = ContentTweakerCore.core().metaRegistry().objectTypes().get(registry.method_30517());
        if (type == null) {
            ContentTweakerCore.LOGGER.info("Unknown registry '{}': are you missing object types for it?", (Object)registry.method_30517());
            return;
        }
        ContentTweakerCore.LOGGER.info("Registering objects for type '{}'", type);
        try {
            FabricGameRegistry.of(registry, type).doRegistration();
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error("A critical internal ContentTweaker error occurred", e);
            ContentTweakerCore.LOGGER.error("A critical internal ContentTweaker error occurred", e);
        }
    }
}

